/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title TxRosterComment
 * @desc TODO
 * @author shanyu
 * @date 2015年12月3日
 * @version 1.0
 */
@Data
@Entity
@Table(name = "tx_student_comment", catalog = "yunying")
public class TxStudentComment implements Serializable {

    private static final long serialVersionUID = -1501425571733740805L;

    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long consultUserId = 0l;

    @Column
    private Long userId = 0l;

    @Column
    private Long orgId = 0l;

    @Column
    // 下载状态
    private Integer downStatus = 0;

    @Column
    private Integer seconds = 0;

    @Column
    // 三方通话接听状态
    private Integer callStatus = 0;

    @Column
    // 是否是通话记录：0，其他；1,三方通话；2,400电话;
    private Integer isMobile = 0;
    
    @Column
    // 是否是系统自动添加
    private Integer isSystem = 0;

    @Column
    private Long soundId = 0l;

    @Column
    private String storageIds = StringUtils.EMPTY;

    @Column
    private String content = StringUtils.EMPTY;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;
    
    //数据来源
    @Column(name = "origin")
    private int origin = 0;
    
    @Column(name = "comment_type")
    private Integer commentType = -1;//跟进记录类型
    
    @Column(name = "is_growth_comment")
    private Integer growthComments = 0;//是否添加到成长记录
    
    @Column(name = "notify_parents")
    private Integer notifyParents = 0;//是否通知家长(即是否添加到成长档案)
    
    @Column(name = "creator_cascade_id")
    private Integer creatorCascadeId = -1;//创建者的 账号id

    @Column(name = "type")
    private Integer type;//跟进记录类型,1:报名/转班/退班跟进
    
    public static void main(String args[]) {
        TxStudentComment tx = new TxStudentComment();
        tx.setContent("");
    }
}
