/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.po;


import java.io.Serializable;
import java.util.Date;

import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;


/**   
 * @title       : TxConsulterOperationLog 
 * @description : 线索 操作记录
 * @author      : zhenyujian
 * @date        : 2016年5月30日 上午1:48:10 
 */
@Data
@Entity
@Table(name = "tx_consult_user_log", catalog = "yunying")
public class TxConsulterOperationLog implements Serializable {

    private static final long serialVersionUID = 4026037240731277179L;

    @Id 
    @GeneratedValue
    private Long id;
    
    @Column(name = "consult_user_id")
    private Long consultUserId;//线索id

    @Column(name = "operator_cascade_id")
    private Long operatorCascadeId;//操作者  0-主账号
    
    @Column(name = "target_cascade_id")
    private Long targetCascadeId;//操作后,线索所属人. (被操作者)  0-主账号
    
    @Column(name = "operation_type")
    private Integer operationType;//操作类型 见ConsulterOperation

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;
    
    public TxConsulterOperationLog(){
    }
    
    public TxConsulterOperationLog(Long consultUserId, Long operatorCascadeId, 
    							   Long targetCascadeId, ConsulterOperation operation){
    	this.consultUserId = consultUserId;
    	this.operatorCascadeId = operatorCascadeId;
    	this.targetCascadeId = targetCascadeId;
    	this.operationType = operation.getValue();
    	Date now = new Date();
    	this.createTime = now;
    	this.updateTime = now;
    	
    }
}
