/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.po;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.baijia.tianxiao.util.HanZiPinYinUtils;

import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author shanyu
 * @version 1.0
 * @title TxRoster
 * @desc 咨询本联系人
 * @date 2015年12月3日
 */
@Data
@Entity
@Table(name = "tx_consult_user", catalog = "yunying")
@Slf4j
public class TxConsultUser extends BaseDto {

    private static final long serialVersionUID = 4026037240731277171L;

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @Column(name = "org_id")
    private Long orgId;

    /**
     * 平台的用户ID
     */
    @Column(name = "user_id")
    private Long userId;

    @Column(name = "user_number")
    private Long userNumber;

    @Column(name = "name")
    private String name;

    @Column(name = "nick_name")
    private String nickName;

    @Column(name = "school")
    private String school;

    @Column(name = "mobile")
    private String mobile;

    @Deprecated
    @Column(name = "weixin")
    private String weixin;

    @Column(name = "weixin_nick_name")
    private String weixinNickName;

    @Column(name = "weixin_app_id")
    private String weixinAppId;

    /**
     * 分析关注机构公众号的唯一ID
     */
    @Column(name = "weixin_open_id")
    private String weixinOpenId;

    /**
     * 咨询消息来源
     */
    @Column(name = "consult_source")
    private Integer consultSource;

    @Column(name = "parent_name")
    private String parentName;

    @Column(name = "parent_mobile")
    private String parentMobile;

    /**
     * 意向级别,0-5
     */
    @Column(name = "intension_level")
    private Integer intensionLevel = 0;

    @Column(name = "consult_status")
    private Integer consultStatus = 1;

    @Column(name = "birthday", defaultVal = "0")
    private Date birthday;

    @Column(name = "next_remind_time", defaultVal = "0")
    private Date nextRemindTime;

    @Column(name = "qq")
    private String qq;

    @Column(name = "mail")
    private String mail;

    @Column(name = "degree_class")
    private String degreeClass;

    @Column(name = "address")
    private String address;

    @Column(name = "father_occupation")
    private String fatherOccupation;

    @Column(name = "mather_occupation")
    private String matherOccupation;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "del_status")
    private Integer delStatus;

    @Column(name = "manually")
    private int manually;

    @Column(name = "student_id")
    private Long studentId;

    //纬度
    @Column(name = "latitude")
    private String latitude;

    //经度
    @Column(name = "longitude")
    private String longitude;

    //用户居住区域对应areaId
    @Column(name = "area_id")
    private Long areaId;

    //name的汉语拼音
    @Column(name = "pinyin")
    private String pinyin;

//    @Column(name = "user_status")
//    private int userStatus;


    //头像
    @Column(name = "portrait")
    private String portrait;
    //亲属关系
    @Column(name = "relatives")
    private Integer relatives;
    //性别
    @Column(name = "sex")
    private Integer sex=-1;
    //校区org_id
    @Column(name = "campus_org_id")
    private Integer campusOrgId;
    //是否是线索
    @Column(name = "is_consulter")
    private Integer isConsulter;
    //所属子账号id 0-表示主账号
    @Column(name = "cascade_id")
    private Long cascadeId;
    //所属客服
    @Column(name = "kefu_id")
    private Long kefuId;
    //有效、无效
    @Column(name = "is_invalid")
    private Integer isInvalid;
    //标志为无效的原因
    @Column(name = "reason_for_invalid")
    private String reasonForInvalid;
    //线索持有的截止时间
    @Column(name = "finally_hold_time")
    private Date finallyHoldTime;

    //最后领取时间
    @Column(name = "last_pull_time")
    private Date lastPullTime;
    //最后释放回公海时间
    @Column(name = "last_push_time")
    private Date lastPushTime;
    //最后置为无效时间
    @Column(name = "last_invalid_time")
    private Date lastInvalidTime;
    //最后查看时间
    @Column(name = "last_browse_time")
    private Date lastBrowseTime;
    //最后跟进时间
    @Column(name = "last_remind_time")
    private Date lastRemindTime;
    
    @Column(name = "custom_search_value")
    private String customSearchValue;

    public String getName() {
        return StringUtils.isNotBlank(name) ? name : TianXiaoConstant.APPOINTMENT_STUDENT_NAME;
    }

    public void setName(String name) {
        this.name = name;
        if (StringUtils.isNotBlank(name)) {
            this.setPinyin( HanZiPinYinUtils.getLowerCasePinYin(name) );
        }
    }
    
    public Map<String,String> toSolrMap() throws IllegalArgumentException, IllegalAccessException{
    	Map<String,String> map = new HashMap<String,String>();
    	
        Class classObj = this.getClass();  
        Field[]  fields = classObj.getDeclaredFields();
        Field field = null;
        Column column = null;
        
        for(int i=0;i<fields.length;i++ ){  
            field = fields[i];  
            column  = field.getAnnotation(Column.class);//得到属性上的注解   
            //log.info("####### "+i +" "+field.getName()+"    "+column+"     "+field.get(this)   );
            if(column!=null){
            	map.put( column.name().toUpperCase() , objToSolrStr(field.get(this)) );
            }
        }
        
    	return map;
    }
    
    String objToSolrStr(Object obj){
    	String str = null;
    	
    	if(obj instanceof Date){
    		if(obj == null){
    			str = "0000-00-00 00:00:00";
    		}else{
    			str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj);
    		}
    	}else{
    		if(obj!=null){
    			str = obj.toString();
        	}
    	}
    	return str;
    }
      
    //http://bug.baijiahulian.com/issues/45004
    public static boolean validateStr(String str){
    	String regex = "[()-_0-9a-zA-Z\u4e00-\u9fa5\uff08\uff09\u2014]*";
        return str.matches(regex);
    }
  
    public static void main(String args[]){
    	String str = "（）()——-_";
    	System.out.println( validateStr(str) );
    }
    
    public void setPinyin(String pinyin){
    	this.pinyin = pinyin;
    	//拼音最多保留120位
    	if(this.pinyin.length()>120){
    		this.pinyin = this.pinyin.substring(0,120);
    	}
    }
    
}