package com.baijia.tianxiao.dal.roster.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 9:25:11 PM
 * @desc : 用户自定义字段存储的值
 */
@Data
@Entity
@Table(name = "tx_custom_field_value", catalog = "yunying")
public class CustomFieldValue {

    @Id
    @GeneratedValue
    @Column
    private Long id;
    @Column(name = "field_id")
    private Long fieldId; // fieldId
    @Column(name = "org_id")
    private Long orgId;
    @Column(name = "consult_user_id")
    private Long consultUserId;
    @Column(name = "student_id")
    private Long studentId;
    @Column(name = "value")
    private String value;// 当前字段的值
    @Column(name = "field_type")
    private Integer fieldType; // 详细见CustomFieldTypes
    @Column(name = "create_time")
    private Date createTime;
    @Column(name = "update_time")
    private Date updateTime;
    
    @Column(name = "search_value")
    private String searchValue;
    
    public CustomFieldValue addOrgId(Long orgId){
        this.setOrgId(orgId);
        return this;
    }
    
    public CustomFieldValue addConsultUserId(Long consultUserId){
        this.setConsultUserId(consultUserId);
        return this;
    }
    
    public CustomFieldValue addStudentId(Long studentId){
        this.setStudentId(studentId);
        return this;
    }

}
