package com.baijia.tianxiao.dal.roster.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 9:06:31 PM
 * @desc :
 */
@Data
@Entity
@Table(name = "tx_custom_field", catalog = "yunying")
public class CustomField {

    @Id
    @GeneratedValue
    @Column
    private Long id;
    @Column
    private Long orgId; // 所属机构的id 对应着org_sub_account 中的记录.主校区及分校区
    // @Column
    // private Integer customType; // 当前自定义字段所属的客户类型 0:学员 1:线索
    @Column
    private String name; // 如果是非系统字段，该字段存id；系统字段存该字段的key
    @Column
    private String defaultValue; // 当前字段的默认值
    @Column
    private Integer type; // 1:文本 2:单选项 3:多选项 4:日期 5:日期时间 6:整数 7浮点数 8:图片 9:位置 10：标签 ([4,*]用于系统默认字段)
    @Column
    private Integer isRequired = 0; // 是否必填0:不是 1:是
    @Column
    private Integer isPaused; // 是否停用 0:不是 1:是
    @Column
    private Integer systemFieldNum = -1; // 如果是系统字段该值对应的是 Enum:SystemFields 中的type字段 ，否则即为-1
    @Column(name = "sorted")
    private Integer sorted; // 当前字段的显示顺序
    @Column
    private Integer sectionId; // 所属section 1:基本信息，2其他信息
    @Column
    private Integer isUsed; // 改字段是否使用过
    @Column
    private Date createTime;
    @Column
    private Date updateTime;

    @Column
    private String label;

}
