/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.dao.impl;

import java.util.Collection;
import java.util.List;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;



@Repository
public class TxConsulterOperationLogDaoImpl extends JdbcTemplateDaoSupport<TxConsulterOperationLog> implements TxConsulterOperationLogDao {

    public TxConsulterOperationLogDaoImpl() {
        super(TxConsulterOperationLog.class);
    }

	@Override
	public List<TxConsulterOperationLog> listByConsultUserId(Long consultUserId, Collection<Integer> operationTypeList) {
		SingleSqlBuilder<TxConsulterOperationLog> builder = createSqlBuilder();
        builder.eq("consultUserId", consultUserId);
        builder.in("operationType", operationTypeList);
        builder.desc("id");
        return queryList(builder);
	}

}
