/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年7月20日
 * @desc
 */
@Slf4j
@Repository
public class TXCustomOptionDaoImpl extends JdbcTemplateDaoSupport<TXCustomOption>
    implements TXCustomOptionDao {
    
    public TXCustomOptionDaoImpl() {
        super(TXCustomOption.class);
    }

    @Override
    public List<TXCustomOption> getTXCustomOptionList(Long parentId) {
        return this.getTXCustomOptionListWithCondition(parentId, null, null);
    }

    @Override
    public List<TXCustomOption> getTXCustomOptionListWithCondition(Long parentId, Boolean isPaused, Integer isDefault) {
        if (parentId == null) {
            log.info("can not retrieval options with the null id ");
            return Collections.emptyList();
        }
        SingleSqlBuilder<TXCustomOption> builder = createSqlBuilder();
        builder.eq("parentId", parentId);
        if (isPaused != null) {
            builder.eq("isPaused", isPaused ? 1 : 0);
        }
        if(isDefault != null){
            builder.eq("isDefault", isDefault);
        }
        builder.asc("id");
        return queryList(builder);
    }

    @Override
    public void batchDeleteOptions(List<Long> ids) {
        SingleSqlBuilder<TXCustomOption> builder = createSqlBuilder();
        builder.in("id", ids);
        this.getNamedJdbcTemplate().update(builder.toDeleteSqlByCondition(), builder.collectConditionValue());
    }

    @Override
    public void deleteOptionsByParentId(Long parentId) {
        SingleSqlBuilder<TXCustomOption> builder = createSqlBuilder();
        builder.eq("parentId", parentId);
        this.getNamedJdbcTemplate().update(builder.toDeleteSqlByCondition(), builder.collectConditionValue());
    }

    @Override
    public TXCustomOption getTXCustomOptionByLabelAndFieldId(String label, Long fieldId) {
        SingleSqlBuilder<TXCustomOption> builder = createSqlBuilder();
        builder.eq("label", label);
        builder.eq("parentId", fieldId);
        return uniqueResult(builder);
    }
    
}
