package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.base.Preconditions;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @author Rezar
 * @createDate :Jul 22, 2016 5:22:51 PM
 * @desc :
 */
@Repository
public class CustomFieldValueDaoImpl extends JdbcTemplateDaoSupport<CustomFieldValue> implements CustomFieldValueDao {

    @Override
    public List<CustomFieldValue> searchValuesByConfig(Long orgId, boolean isStudent, Long studentIdOrConsultId, List<Long> customFieldIds) {
        SingleSqlBuilder<CustomFieldValue> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if(isStudent){
            builder.eq("studentId", studentIdOrConsultId);
        }else{
            builder.eq("consultUserId", studentIdOrConsultId);
        }
        if(customFieldIds!=null){
            builder.in("fieldId", customFieldIds);
        }
        
        return queryList(builder);
    }

    @Override
    public CustomFieldValue getCustomFieldValue(Long fieldId, boolean isStudent, Long studentIdOrConsultId) {
        SingleSqlBuilder<CustomFieldValue> builder = createSqlBuilder();
        if(studentIdOrConsultId != null){
            if(isStudent){
                builder.eq("studentId", studentIdOrConsultId);
            }else{
                builder.eq("consultUserId", studentIdOrConsultId);
            }
        }
        builder.eq("fieldId", fieldId);
        List<CustomFieldValue> list = queryList(builder);
        if(list != null && list.size() >0){
            return list.get(0);
        }else{
            return null;
        }
    }

	@Override
	public void updateStudentId(Long orgId, Long consultId, Long studentId) {
		String sql = "UPDATE yunying.tx_custom_field_value SET student_id=:studentId WHERE consult_user_id=:consultId AND org_id=:orgId";
		
        Map<String, Object> params = new HashedMap<String, Object>();
        params.put("studentId", studentId);
        params.put("consultId", consultId);
        params.put("orgId", orgId);

        getNamedJdbcTemplate().update(sql, params);
	}

    @Override
    public Map<Long, List<CustomFieldValue>> batchGetValueMap(Long orgId, final boolean isStudent, Collection<Long> coll, Collection<Long> customFieldIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(coll), "coll can not be empty");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(customFieldIds), "customFieldIds can not be empty");

        SingleSqlBuilder<CustomFieldValue> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if(isStudent){
            builder.in("studentId", coll);
        }else{
            builder.in("consultUserId", coll);
        }
        builder.in("fieldId", customFieldIds);

        final Map<Long, List<CustomFieldValue>> map = new HashMap<>();

        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                CustomFieldValue po = new CustomFieldValue();
                po.setId(rs.getLong("id"));
                po.setFieldId(rs.getLong("fieldId"));
                po.setOrgId(rs.getLong("orgId"));
                po.setConsultUserId(rs.getLong("consultUserId"));
                po.setStudentId(rs.getLong("studentId"));
                po.setValue(rs.getString("value"));
                po.setFieldType(rs.getInt("fieldType"));
                po.setCreateTime(rs.getDate("createTime"));
                po.setUpdateTime(rs.getDate("updateTime"));

                Long userId = null;
                List<CustomFieldValue> list = null;
                if (isStudent) {
                    userId = po.getStudentId();
                } else {
                    userId = po.getConsultUserId();
                }
                list = map.get(userId);
                if (list == null) {
                    list = new ArrayList<CustomFieldValue>();
                    map.put(userId, list);
                }
                list.add(po);
            }
        });
        return map;
    }
}
