/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年7月20日
 * @desc
 */
@Repository
@Slf4j
public class CustomFieldDaoImpl extends JdbcTemplateDaoSupport<CustomField> implements CustomFieldDao {

    @Override
    public List<CustomField> getCustomFieldList(Long orgId, Integer isSystem) {
        SingleSqlBuilder<CustomField> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        
        if(isSystem != null){
            if(isSystem == AddType.NOT_SYSTEM.getCode()){
                builder.eq("systemFieldNum", -1);
            }else{
                builder.gt("systemFieldNum", -1);
            }
        }
        builder.desc("sorted");
        return queryList(builder);
        
    }

    @Override
    public List<CustomField> getCustomFieldListWithCondition(Long orgId, Boolean isPaused) {
        SingleSqlBuilder<CustomField> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (isPaused != null) {
            builder.eq("isPaused", isPaused ? 1 : 0);
        }
        builder.desc("sorted");
        return queryList(builder);
    }

    @Override
    public CustomField getCustomFieldById(Long orgId, Long fieldId) {
        SingleSqlBuilder<CustomField> builder = createSqlBuilder();
        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        builder.eq("id", fieldId);
        return uniqueResult(builder);
    }

    @Override
    public List<CustomField> getCustomFieldsByOrgId(Long orgId) {
        SingleSqlBuilder<CustomField> builder = createSqlBuilder();
        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        return queryList(builder);
    }

    @Override
    public boolean hasInitSystemField(Long orgId) {
        SingleSqlBuilder<CustomField> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.gt("systemFieldNum", -1);
        builder.count("id");
        Integer queryForObject = queryForObject(builder, Integer.class);
        log.info("[CustomFieldDaoImpl] 系统字段个数 queryForObject param:{}", queryForObject);
        boolean hasInitSystemField = true;
        if(queryForObject == null || queryForObject == 0){
            hasInitSystemField = false;
        }
        return hasInitSystemField;
    }

    @Override
    public void batchInsert(List<CustomField> generatorCustomFields) {
        saveAll(generatorCustomFields);
    }
    
    

}
