package com.baijia.tianxiao.dal.roster.dao;

import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.List;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 10:14:06 PM
 * @desc :
 */
public interface TXCustomOptionDao extends CommonDao<TXCustomOption> {
    /**
     * 获取未删除选项字段列表
     */
    public List<TXCustomOption> getTXCustomOptionList(Long parentId);
    
    /**
     * 根据条件进行选项子选项的查找
     * 
     * @param parentId
     * @param isDel
     * @param isPaused 0
     * @param isDefault 0否，1是
     * @return
     */
    List<TXCustomOption> getTXCustomOptionListWithCondition(Long parentId, Boolean isPaused, Integer isDefault);
    
    /**
     * 批量删除子选项
     */
    public void batchDeleteOptions(List<Long> ids);
    
    /**
     * 按照parentId删除所有子选项
     */
    public void deleteOptionsByParentId(Long parentId);
    
    /**
     * 按照label和fieldId来找子选项配置
     * @param label
     * @param fieldId
     * @return
     */
    public TXCustomOption getTXCustomOptionByLabelAndFieldId(String label, Long fieldId);
}
