package com.baijia.tianxiao.dal.roster.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuxp on 16/5/27.
 */
public enum RuleType {

    CALL(1,"是否可本人电话致电学员"),
    CONSULT_ALLOCATE(2,"客户咨询分配规则"),
    APPOINTMENT(3,"预约留单规则"),
    CLUE_ALLOCATE(4,"线索分配规则"),
    RETREAT(5,"退回规则"),
    TO_VALID(6,"无效转有效规则"),
    CLUE_COUNT_LIMIT(7,"线索限制"),
    FOLLOW_DAY_COUNT(8,"跟进日期限制"),
    SOURCE(9,"来源设置");

    private  static Map<Integer,RuleType>  ruleTypeMap = new HashMap<>();
    static {
        for (RuleType type:RuleType.values()){
            ruleTypeMap.put(type.getValue(),type);
        }
    }

    private int value;
    private String desc;

    private RuleType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static RuleType getRuleType(int value){
        return ruleTypeMap.get(value);
    }
}
