
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.constant;

import com.baijia.tianxiao.dal.commons.ConfigEnum;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0
 * @title IntentionLevel
 * @desc 意向级别
 * @date 2016年5月25日
 */

public enum IntentionLevel {

    LEVEL_1(0, "低", ""),
    LEVEL_2(1, "中", ""),
    LEVEL_3(2, "高", ""),;

    private static Map<Integer, String> map = Maps.newHashMap();
    private static Map<String, Integer> nameMap = Maps.newHashMap();
    
    private static Map<Integer, IntentionLevel> intentionLevelMap = Maps.newHashMap();;

    static {
        for (IntentionLevel p : values()) {
            map.put(p.getValue(), p.getLabel());
        }
    }
    
    static{
        for (IntentionLevel p : values()) {
            intentionLevelMap.put(p.getValue(), p);
        }
    } 

    static {
        for (IntentionLevel p : values()) {
            nameMap.put(p.getLabel(), p.getValue());
        }
    }

    public static IntentionLevel getIntentionLevel(Integer value){
        return intentionLevelMap.get(value);
    }
    public static String getLabel(Integer value) {
        String lab = map.get(value);
        return lab == null ? LEVEL_2.getLabel() : lab;
    }

    public static Integer getValue(String label) {
        return nameMap.get(label);
        //return val == null ? LEVEL_2.getValue() : val;
    }


    private int value;
    private String label;
    private String img;

    IntentionLevel(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public String getImg() {
        return img;
    }

    public static List<ConfigEnum> list() {
        List<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (IntentionLevel p : values()) {
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getLabel());
            po.setImg(p.getImg());
            list.add(po);
        }
        return list;
    }


    public static List<Integer> listValues() {
        List<Integer> list = new ArrayList<Integer>();
        for (IntentionLevel p : values()) {
            list.add(p.getValue());
        }
        return list;
    }

}
