package com.baijia.tianxiao.dal.roster.constant;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 15/12/9.
 */
@Slf4j
public enum EncrollmentTypeEnum {
    WULEIXING(-1, "无类型"),
    //FANGKE(1, "访客"),  //下期待定
    ZIXUN(2, "访客"),
    GOUTONG(3, "已沟通学员"),
    YIXIANG(4, "试听或有意向"),
    BAOMING(5, "已报名");

    private int value;
    private String name;

    EncrollmentTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    public static EncrollmentTypeEnum swicthEncrollmentTypeEnum(int type){
        switch(type){
            case 0:
                return EncrollmentTypeEnum.ZIXUN;
            case 1:
                return EncrollmentTypeEnum.GOUTONG;
            case 2:
                return EncrollmentTypeEnum.YIXIANG;
            case 3:
                return EncrollmentTypeEnum.BAOMING;
        }
        
        log.warn("[EncrollmentTypeEnum] type is error.type="+ type);
        return null;
    }
}
