
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.roster.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.google.common.collect.Maps;

/**
 * @version 1.0
 * @title ConsulterOperation
 * @desc
 * @date 2016年5月25日
 */

public enum ConsulterOperation {

    PUSH_AUTO(0, "自动回归公海"),
    PUSH_MANUAL(1, "手动释放回公海"),
    PASSTO(2, "转交"),
    PULL(3, "手动领取"),
    ASSIGN(4, "主管分配");

    private int value;
    private String label;

    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (ConsulterOperation p : values()) {
            map.put(p.getValue(), p.getLabel());
        }
    }

    public static String getLabel(int value) {
        return map.get(value);
    }


    private ConsulterOperation(int value, String label) {
        this.value = value;
        this.label = label;
    }

    public int getValue() {
        return value;
    }
    
    public String getLabel() {
        return label;
    }


    public static List<ConfigEnum> list() {
        List<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (ConsulterOperation p : values()) {
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getLabel());
            list.add(po);
        }
        return list;
    }

}
