package com.baijia.tianxiao.dal.roster.constant;

import com.baijia.tianxiao.dal.commons.ConfigEnum;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 15/12/8.'
 * 跟进状态
 */
public enum ConsultUserStatus {
	NOT(1, "未处理", ""),
	HAS(0, "已联系", ""),
    YAOYUE(2, "邀约上门", ""),
    YUYUE(3, "预约试听", ""),
    DINGJIN(4, "已交订金", ""),
    DIUDAN(5, "已丢单", ""),
    WUXIAO(6, "无效", "");

    private static Map<Integer, ConsultUserStatus> map = Maps.newHashMap();

    private static Map<String, Integer> nameMap = Maps.newHashMap();

    static {
        for (ConsultUserStatus p : values()) {
            nameMap.put(p.getLabel(), p.getValue());
            map.put(p.getValue(), p);
        }
    }

    public static String getLabel(int value) {
    	ConsultUserStatus lab = map.get(value);
    	if(lab==null) return null;
        return lab.label;
    }

    public static Integer getValue(String label) {
        return nameMap.get(label);
        //return val == null ? NOT.getValue() : val;
    }
    public static ConsultUserStatus getConsultUserStatus(Integer value){
        return map.get(value);
    }

    private int value;
    private String label;
    private String img;

    private ConsultUserStatus(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public String getImg() {
        return img;
    }

    public static List<ConfigEnum> list() {
        List<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (ConsultUserStatus p : values()) {
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getLabel());
            po.setImg(p.getImg());
            list.add(po);
        }
        return list;
    }

    public static List<Integer> listValues() {
        List<Integer> list = new ArrayList<Integer>();
        for (ConsultUserStatus p : values()) {
            list.add(p.getValue());
        }
        return list;
    }
    
    public static List<Integer> listValuesWithoutWuxiao() {
        List<Integer> list = listValues();
        list.remove(ConsultUserStatus.WUXIAO.getValue());
        return list;
    }
    
    public static List<ConfigEnum> listWithoutWuxiao() {
    	List<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (ConsultUserStatus p : values()) {
        	if(p == ConsultUserStatus.WUXIAO){
        		continue;
        	}
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getLabel());
            po.setImg(p.getImg());
            list.add(po);
        }
        return list;
    }
    
    public static void main(String args[]){
    	System.out.println(ConsultUserStatus.getLabel(0));
    }
}
