package com.baijia.tianxiao.dal.push.po;

/**
 * Created by liuxp on 16/5/23.
 */

import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 唯一标示一个用户实体
 */
@Data
public class UserIdentify {
    private long userId;
    private Long orgNumber;//机构Number
    private Long cascadeId;//机构子账号
    private MsgUserRole userRole;
    private List<Integer> allRoleIds;

    /**
     * 验证信息的有效性
     * @return
     */
    public boolean validate(){
        if(MsgUserRole.getOrgUsers().contains(userRole)){
            //机构类用户，除了总账号（校长），必须有子账号ID
            if(userRole != MsgUserRole.HEADER && cascadeId==null){
                return false;
            }
        }
        return true;
    }

    public List<Integer> getAllRoleIds(){
        List<Integer> list = new ArrayList<>();
        if(MsgUserRole.isStu(userRole.getValue())){
            for(MsgUserRole userRole:MsgUserRole.getStuUsers()){
                list.add(userRole.getValue());
            }
        }
        if(MsgUserRole.isOrg(userRole.getValue())){
            for(MsgUserRole userRole:MsgUserRole.getOrgUsers()){
                list.add(userRole.getValue());
            }
        }
        return list;
    }
}
