package com.baijia.tianxiao.dal.push.po;

import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * Created by liuxp on 16/6/3.
 */
@Entity
@Data
@Table(name = "tx_message", catalog = "yunying")
public class TxMessage {

    @Id
    @GeneratedValue
    private long id;// 消息ID

    @Column
    private int msgType;// 消息类型：0(文本), 1(图片), 2(语音), 3(位置), 5(卡片)

    @Column
    private long senderId;// 消息发送人ID

    @Column
    private Long senderNumber;//发送消息人的Number

    @Column(name="sender_role")
    private int senderRole;//发送人角色

    @Column
    private long receiverId;// 消息接收人ID

    @Column(name="receiver_role")
    private int receiverRole;//接收人角色

    @Column(name = "consult_type")
    private int consultType;// 0(手动录入)| 1(来电咨询) | 2(微信咨询) | 3(预约留单)

    @Column
    private Date createTime;// 记录创建时间

    @Column(name = "content")
    private String content;

    @Column
    private long orgId;
}
