package com.baijia.tianxiao.dal.push.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * Created by lxp on 15/12/3.
 */
@Entity
@Data
@Table(name = "tx_message_record", catalog = "yunying")
public class ConsultMessage {
    @Id
    @GeneratedValue
    @Column
    private long id;// 消息ID

    @Column(name = "msg_type")
    private int msgType;// 消息类型：0(文本), 1(图片), 2(语音), 3(位置), 5(卡片)

    @Column(name = "sender_id")
    private long senderId;// 消息发送人ID

    @Column(name = "sender_number")
    private Long senderNumber;//发送消息人的Number

    @Column(name="sender_role")
    private int senderRole;//发送人角色

    @Column(name = "receiver_id")
    private long receiverId;// 消息接收人ID

    @Column(name="receiver_role")
    private int receiverRole;//接收人角色

    @Column
    private String url = "";// 图片或语音的地址

    @Column
    private int width;// 图片宽度

    @Column
    private int height;// 图片高度

    @Column
    private int length;// 语音长度

    @Column
    private Long callId = 0L; // 电话

    @Column(name = "consult_type")
    private int consultType;// 0(手动录入)| 1(来电咨询) | 2(微信咨询) | 3(预约留单)

    @Column
    private Date createTime;// 记录创建时间

    @Column
    private Integer storageId = 0;//storageId

    @Column(name = "content")
    private String content;
    
    @Column(name = "org_id")
    private Long orgId;

}
