package com.baijia.tianxiao.dal.push.dao.impl;

import com.baijia.tianxiao.dal.push.dao.MsgPulledRecordDao;
import com.baijia.tianxiao.dal.push.po.MsgPulledRecord;
import com.baijia.tianxiao.dal.push.utils.DbParamBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * Created by liuxp on 15/12/3.
 */
@Repository
@Slf4j
public class MsgPulledRecordDaoImpl extends JdbcTemplateDaoSupport<MsgPulledRecord> implements MsgPulledRecordDao {

    public MsgPulledRecordDaoImpl() {
        super(MsgPulledRecord.class);
    }

    @Override
    public void insertPulledRecord(MsgPulledRecord record) {
        save(record, false);
    }

    @Override
    public MsgPulledRecord selectPulledRecordByUserId(long userId, Integer cascadeId, String deviceId) {
        String sql = "select * from yunying.tx_msg_pull_record where user_id = :userId and cascade_id=:cascadeId and device_id=:deviceId";
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> param = DbParamBuilder.getInstance()
                .add("userId", userId)
                .add("cascadeId",cascadeId)
                .add("deviceId",deviceId)
                .build();
        log.info("[MsgPulledRecord] param={}",param);
        return template.query(sql, param,
                new ResultSetExtractor<MsgPulledRecord>() {
                    @Override
                    public MsgPulledRecord extractData(ResultSet rs) throws SQLException, DataAccessException {
                        if (rs.next()) {
                            MsgPulledRecord obj = new MsgPulledRecord();
                            obj.setId(rs.getLong("id"));
                            obj.setMsgId(rs.getLong("msg_id"));
                            obj.setUserId(rs.getLong("user_id"));
                            obj.setUpdateTime(rs.getTime("update_time"));
                            obj.setCascadeId(rs.getInt("cascade_id"));
                            obj.setDeviceId(rs.getString("device_id"));
                            return obj;
                        }
                        return null;
                    }
                });
    }

    @Override
    public void updatePulledRecord(long userId, Integer cascadeId, String deviceId, long msgId) {
        Map<String, Object> paramMap = DbParamBuilder.getInstance()
                .add("userId", userId)
                .add("msgId", msgId)
                .add("deviceId", deviceId)
                .add("cascadeId", cascadeId)
                .build();
        String sql = "update yunying.tx_msg_pull_record set msg_id = :msgId where user_id = :userId and device_id=:deviceId  and cascade_id=:cascadeId";
        getNamedJdbcTemplate().update(sql, paramMap);
    }
}
