package com.baijia.tianxiao.dal.push.dao.impl;

import com.baijia.tianxiao.dal.push.constant.MsgSettingStatus;
import com.baijia.tianxiao.dal.push.dao.AccountMsgSettingDao;
import com.baijia.tianxiao.dal.push.po.AccountMsgSetting;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/6/1.
 */
@Repository
@Slf4j
public class AccountMsgSettingDaoImpl extends JdbcTemplateDaoSupport<AccountMsgSetting> implements AccountMsgSettingDao {

    @Override
    public void insertAccountMsgSetting(AccountMsgSetting setting) {
        save(setting);
    }

    @Override
    public void updateAccountMsgSetting(AccountMsgSetting setting) {
        update(setting,false);
    }

    @Override
    public AccountMsgSetting selectAccountMsgSetting(Long orgId, Integer cascadeId) {
        SingleSqlBuilder<AccountMsgSetting> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("cascadeId", cascadeId==null?0:cascadeId);
        List<AccountMsgSetting> list = queryList(builder);
        if (list != null && list.size() > 0) {
            return list.get(0);
        } else {
            return null;
        }
    }

    @Override
    public List<AccountMsgSetting> getAccountMsgSettingList(Long orgId, Collection<Integer> cascadeIds) {
        SingleSqlBuilder<AccountMsgSetting> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.in("cascadeId", cascadeIds);
        return this.queryList(builder);
    }

    @Override
    public List<AccountMsgSetting> selectSettingByOrgId(Long orgId, Integer status) {
        SingleSqlBuilder<AccountMsgSetting> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if(status!=null){
            builder.eq("msgSwitch",status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<AccountMsgSetting> getAccountMsgSettingExceptItSelf(Long orgId, Integer cascadeId) {
        SingleSqlBuilder<AccountMsgSetting> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.ne("cascadeId", cascadeId);
        builder.eq("msgSwitch", MsgSettingStatus.OPEN.getValue());
        return this.queryList(builder);
    }
}
