package com.baijia.tianxiao.dal.push.dao;


import com.baijia.tianxiao.dal.push.dto.ConsultMessageDto;
import com.baijia.tianxiao.dal.push.dto.MsgRecordDto;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.po.UserIdentify;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 15/12/3.
 */
public interface MessageDao {

    void batchInsertMessage(List<ConsultMessage> messages);

    void insertMessage(ConsultMessage message);

    List<ConsultMessage> selectNewOrgRecordList(long userId, Integer cascadeId, long msgId, int limit);

    /**
     * 获取两个用户的聊天记录
     * @param user1
     * @param user2
     * @param msgId
     * @param limit
     * @return
     */
    List<ConsultMessage> selectDialogMsgByUserId(UserIdentify user1,UserIdentify user2,long msgId, int limit);

    List<ConsultMessage> getConsultMessageListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps);
    
    /**
     * 获取机构留单数
     */
    Map<String, Long> getOrgLeaveBill(Long orgNumber, Date startTime, Date endTime);

    /**
     * 获取机构总留单数
     *
     * @param orgNumber
     * @return
     */
    int getOrgLeaveBillCount(Long orgNumber);

    int getPeroidOrgLeaveBill(Long orgNumber, Date startTime, Date endTime);

    /**
     * 获取机构电话咨询数
     *
     * @param orgNumber
     * @return
     */
    Map<String, Long> getOrgCall(Long orgNumber, Date startTime, Date endTime);

    /**
     * 获取机构电话咨询总数
     *
     * @param orgNumber
     * @return
     */
    int getOrgCallCount(Long orgNumber);

    int getPeroidOrgCall(Long orgNumber, Date startTime, Date endTime);


    void refreshConsultMessage(Long orgNumber, Long id);


    /**
     * 获取机构线索总数
     */
    Integer getOrgClueTotal(Long orgNumber);

    Integer getPeriodOrgClue(Long orgNumber, String startTime, String endTime);

    /**
     * 获取机构微信咨询总数
     */
    Integer getOrgWechatClue(Long orgNumber);

    Integer getPeriodOrgWechatClue(Long orgNumber, String startTime, String endTime);

    /**
     * 获取所有被咨询的机构orgNamber  线索
     */
    public List<Long> getExistOrgNumbers();

    /**
     * 按类型获取机构线索
     */
    public Map<Long, Integer> getConsultCountByType(Date startDate, Date endDate, int consultType, List<Integer> TianxiaoOrgNumbers);

    /**
     * 获取机构所有线索
     */
    public Map<Long, Integer> getConsultCountByTypeAndOrgIds(Date startTime, Date endTime, int consultType, List<Long> orgIds);

    /**
     * 获取机构除去微信线索的所有线索
     * @param startDate
     * @param endDate
     * @return
     */
    public Map<Long, Integer> getConsultTotal(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers);

    public Map<Long, Integer> getConsultTotalByOrgIds(Date startTime, Date endTime, List<Long> orgIds );

    /**
     * 获取机构微信线索消息和预约留单线索消息
     */
    public List<MsgRecordDto> getMsgRecordDtoListByOrgIds(List<Integer> TianxiaoOrgNumbers);

    /**
     * 按日期统计线索总数
     * @param startDate
     * @param endDate
     * @param TianxiaoOrgNumbers
     * @return
     */
    public Map<String, Integer> getConsultTotalMapByDate(Date startDate, Date endDate, List<Long> orgIds);
    
    /**
     * 根据机构orgNumber或者子帐号获取咨询记录
     * @param orgOrCascadeRoles
     */
    public List<ConsultMessageDto> getMsgDtoByOrgNumberOrCacadeId(Integer number, List<Integer> orgOrCascadeRoles, List<Integer> consultRoles);
    
    /**
     * 根据筛选条件和机构number或者子帐号获取咨询总数
     */
    public Integer getMsgTotal(Integer numberOrCascadeId, List<Integer> orgOrCascadeRoles, List<Integer> consultRoles, Integer typeSource, Date startTime, Date endTime );
    
    /**
     * 根据用户id 获取会话，如果有多条就获取最新的一条
     */
    public ConsultMessage getConsultMessageBySenderId(Long senderId, Long orgId);
    
    /**
     * 根据筛选条件获取咨询列表
     */
    public List<ConsultMessageDto> getMsgListByFilter(Integer numberOrCascadeId, List<Integer> orgOrCascadeRoles, List<Integer> consultRoles, 
        Integer typeSource, Date startTime, Date endTime, Integer start, Integer limit);
    

    public List<ConsultMessage> selectDialogMsg(UserIdentify user1, UserIdentify user2, Long lastMsgId, Integer limit, boolean gtLastMsgId);

    public  List<ConsultMessage> selectMsgByPageDto(PageDto dto,int maxId,int minId);

    public void update(ConsultMessage message);

}
