package com.baijia.tianxiao.dal.push.constant;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 15/12/7.
 */

public enum MessageSource {
	
    INPUT       (0, "门店到访", true, true),
    TELEPHONE   (1, "400电话", true, true ),
    WECHAT      (2, "微信咨询", true, true ),
    APPOINTMENT (3, "预约留单", true, true ),
    ONLINE_IM   (4, "在线咨询", true, false ),
    MARKING     (5, "推广消息", false, false),
    SIGNUP      (6, "发活动", true, true ),
    WEI_OFFICIAL(8,   "微官网", false, false),
    STAFF_INFO  (9, "同事消息", false, false),
    IMPORT      (10,"线索导入", true, false ),
    NOTICE      (100,  "通知", false, false),
    VZHIBO		(11,"微直播",true,true);

    
    
    
    
    private int value;
    private String desc;
    private boolean isConsultSource;//是否是线索来源
    private boolean inSourceSelection;//线索来源 是否展示在列表中
    
    
    private static Map<Integer, MessageSource> mapping = Maps.newHashMap();
    
    static {
        for (MessageSource ct : MessageSource.values()) {
            mapping.put(ct.value, ct);
        }
    }
    
    public static String getDesc(Integer code) {
        if(mapping.get(code)==null){
            return null;
        }
        return mapping.get(code).getDesc();
    }
    
    public static MessageSource getByType(Integer code) {
        return mapping.get(code);
    }
    
    
    

    
    //构造方法
    private MessageSource(int value, String desc, boolean isConsultSource, boolean inSourceSelection) {
        this.value = value;
        this.desc = desc;
        this.isConsultSource = isConsultSource;
        this.inSourceSelection = inSourceSelection;
    }
    
    
    
    //GET 方法
    public int getValue() {
        return value;
    }
    public String getDesc() {
        return desc;
    }
    public boolean isConsultSource(){
    	return isConsultSource;
    }
    
    
    //消息格式
    public String buildConsultTypeMsg(String msg) {
        String fmt = "%s$%s";
        return String.format(fmt, this.getValue(), msg);
    }



    
    public static List<MessageSource> listConsultSource(Boolean sourceSelection){
        List<MessageSource> list = new ArrayList<MessageSource>();
        
        for (MessageSource obj : values()) {
        	if(obj.isConsultSource){
        		if(sourceSelection!=null){
        			if(sourceSelection && obj.inSourceSelection){
        				list.add(obj);
        			}
        		}else{
        			list.add(obj);
        		}
        	}
        }
        return list;
    }

    
    
    
    public static String getText(MessageSource source){
        switch(source){
           case TELEPHONE:
               return "400";
           case WECHAT:
               return "微信";
           case WEI_OFFICIAL:
               return "微官网";
           case APPOINTMENT:
               return "留单";
           case SIGNUP:
               return "活动";
        }
        return null;
    }

    
   
}
