/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.pcAuthority.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title TxRolePermission
 * @desc 天校各种级别,各种身份对应的默认权限表
 * @author hongyan
 * @date 2016年8月1日
 * @version version
 */
@Data
@Entity
@Table(name = "tx_role_permission", catalog = "yunying")
public class TxRolePermission {
    @Id
    @GeneratedValue
    private Integer id;
    @Column(name = "p_id")
    private Integer pId;// tx_permission.id
    @Column(name = "p_code")
    private Long pCode;// 对外暴露权限代码，全局唯一，tx_permission.code
    @Column(name = "p_type")
    private Integer pType;// 权限类型 0-拥有 1-失去
    @Column(name = "role")
    private Integer role;// 角色：1-总校校长 2-分校校长 3-主管 4-员工
    @Column(name = "vip_level")
    private Integer vipLevel;// 账户级别：1-专业版 2-企业版 3-旗舰版 4-定制版 5-大众版 6-白金版
    @Column(name = "isdel")
    private Integer isdel;// 删除状态：0=正常,1=已删除
    @Column(name = "create_time")
    private Date createTime;
    @Column(name = "update_time")
    private Date updateTime;
    @Column(name = "device_type")
    private Integer deviceType;// 当前权限应用平台：0-pc 1-app
}
