package com.baijia.tianxiao.dal.pcAuthority.dao.impl;

import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @title TXPermissionDaoImpl
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月2日
 * @version 1.0
 */

@Repository
public class TXPermissionDaoImpl extends JdbcTemplateDaoSupport<TXPermission> implements TXPermissionDao {

    @Override
    public List<TXPermission> geTxPermissions(List<Long> codes) {
        SingleSqlBuilder<TXPermission> builder = createSqlBuilder();
        builder.in("code", codes);
        builder.asc("code");
        return queryList(builder);
    }

    @Override
    public TXPermission getTXPermission(Long code) {
        SingleSqlBuilder<TXPermission> builder = createSqlBuilder();
        builder.eq("code", code);
        return uniqueResult(builder);
    }
}
