package com.baijia.tianxiao.dal.pcAuthority.dao.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.dao.ApplicationAuthConfigDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :May 29, 2016 11:05:07 PM
 * @desc :
 */
@Repository
@Slf4j
public class ApplicationAuthConfigDaoImpl extends JdbcTemplateDaoSupport<ApplicationAuthConfig>
    implements ApplicationAuthConfigDao {

    @Override
    public List<ApplicationAuthConfig> getByIdsAndApplicationType(List<Long> pIds, Integer applicationType) {
        if (GenericsUtils.isNullOrEmpty(pIds)) {
            return Collections.emptyList();
        }
        if (applicationType == null) {
            applicationType = ApplicationType.APP.type;
        }

        SingleSqlBuilder<ApplicationAuthConfig> builder = createSqlBuilder();
        builder.in("id", pIds);
        builder.eq("applicationId", applicationType);

        List<ApplicationAuthConfig> queryList = queryList(builder);
        if (GenericsUtils.isNullOrEmpty(queryList)) {
            return Collections.emptyList();
        }
        return queryList;
    }

    // @Override
    // public List<ApplicationAuthConfig> findApplicationAuthConfig(List<Long> ApplicationAuthConfigIds) {
    // if (GenericsUtils.isNullOrEmpty(ApplicationAuthConfigIds)) {
    // return Collections.emptyList();
    // }
    //
    // SingleSqlBuilder<ApplicationAuthConfig> builder = createSqlBuilder();
    // builder.in("id", ApplicationAuthConfigIds);
    // List<ApplicationAuthConfig> menus = queryList(builder);
    // log.info("find menus's size : {} ", menus.size());
    // return menus;
    // }
    //
    // public void batchInsert(){
    //
    // }

}
