package com.baijia.tianxiao.dal.pcAuthority.constant;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

/**
 * @author Rezar
 * @createDate :May 30, 2016 12:33:02 AM
 * @desc :
 */
public enum RoleType {

    PRESIDENT(1, "总校校长"),
    BRANCH_SCH_PRESIDENT(2, "分校校长"),
    CHARAGE(3, "主管"),
    EMPLOYEE(4, "员工"),
    ;
    public Integer type;
    public String desc;

    private static BiMap<Integer, RoleType> typeInfos = HashBiMap.<Integer, RoleType> create();

    static {
        RoleType[] values = RoleType.values();
        for (RoleType value : values) {
            typeInfos.put(value.type, value);
        }
    }

    RoleType(Integer typeValue, String desc) {
        this.type = typeValue;
        this.desc = desc;
    }

    public static Integer getType(RoleType typeEnum) {
        return typeInfos.inverse().get(typeEnum);
    }

    public static RoleType getRoleType(Integer typeValue) {
        return typeInfos.get(typeValue);
    }

    public static String getRoleTypeDesc(Integer typeValue) {
        RoleType roleType = getRoleType(typeValue);
        if (roleType == null) {
            return "";
        } else {
            return roleType.desc;
        }
    }

}
