package com.baijia.tianxiao.dal.pcAuthority.constant;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

/**
 * @author Rezar
 * @createDate :May 30, 2016 12:03:40 AM
 * @desc :
 */
public enum PermissionOperationType {

    CAN_USE(0, "权限可用"), CAN_NOT_USE(1, "权限不可用");

    public Integer type;
    public String desc;

    private static BiMap<Integer, PermissionOperationType> typeInfos =
        HashBiMap.<Integer, PermissionOperationType> create();

    static {
        PermissionOperationType[] values = PermissionOperationType.values();
        for (PermissionOperationType value : values) {
            typeInfos.put(value.type, value);
        }
    }

    private PermissionOperationType(Integer type, String desc) {
        this.type = type;
    }

    public static Integer getType(PMasterType typeEnum) {
        return typeInfos.inverse().get(typeEnum);
    }

    public static PermissionOperationType getPMasterType(Integer typeValue) {
        return typeInfos.get(typeValue);
    }

}
