
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.po;

import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**
 * @title TXSaleClueRule
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */
@Entity
@Table(catalog = "yunying", name = "tx_sale_clue_rule")
public class TXSaleClueRule {
	
	public static final String CONSULT_SOURCE_SORT_SPLIT = ",";
	
    @Id
    @GeneratedValue
    private Integer id;//天校帐号表主键
    @Column(name = "org_id")
    private Integer orgId;//机构id，对应yunying.org_account.id
    @Column(name = "org_number")
    private Integer orgNumber;//机构number，对应yunying.org_account.number
    @Column(name = "clue_allot")
    private Integer clueAllot;//线索分配规则：0-主管分配员工可领取 1-主管分配员工不可领取 2-自动顺序分配
    @Column(name = "return_clue")
    private Integer returnClue;//跟进期内，退回线索：0-员工可退回线索 1-员工不可退回线索
    @Column(name = "clue_trans_valid")
    private Integer clueTransValid;//无效线索转有效后：0-转入私海 1-转入公海
    @Column(name = "max_clue_count")
    private Integer maxClueCount;//最大跟进线索数
    @Column(name="max_clue_delay")
    private Integer maxClueDelay;//最长跟进时长
    @Column(name = "create_time")
    private Date createTime;//创建时间
    @Column(name = "update_time")
    private Date updateTime;//最新更新时间
    
    @Column(name="consult_source_sort")
    private String consultSourceSort;//线索来源排序
    
    @Column(name="attend_class_msg")
    private Integer attendClassMsg; // 上课提醒
    @Column(name="signup_msg")
    private Integer signupMsg; // 是否发送报名提醒
    @Column(name="signin_msg")
    private Integer signinMsg; // 是否发送签到提醒
    @Column(name="evaluate_msg")
    private Integer evaluateMsg; // 评价提醒
    
    public Integer getId() {
    
        return id;
    }
    public void setId(Integer id) {
    
        this.id = id;
    }
    public Integer getOrgId() {
    
        return orgId;
    }
    public void setOrgId(Integer orgId) {
    
        this.orgId = orgId;
    }
    public Integer getOrgNumber() {
    
        return orgNumber;
    }
    public void setOrgNumber(Integer orgNumber) {
    
        this.orgNumber = orgNumber;
    }
    public Integer getClueAllot() {
    
        return clueAllot;
    }
    public void setClueAllot(Integer clueAllot) {
    
        this.clueAllot = clueAllot;
    }
    public Integer getReturnClue() {
    
        return returnClue;
    }
    public void setReturnClue(Integer returnClue) {
    
        this.returnClue = returnClue;
    }
    public Integer getClueTransValid() {
    
        return clueTransValid;
    }
    public void setClueTransValid(Integer clueTransValid) {
    
        this.clueTransValid = clueTransValid;
    }
    public Integer getMaxClueCount() {
    
        return maxClueCount;
    }
    public void setMaxClueCount(Integer maxClueCount) {
    
        this.maxClueCount = maxClueCount;
    }
    public Integer getMaxClueDelay() {
    
        return maxClueDelay;
    }
    public void setMaxClueDelay(Integer maxClueDelay) {
    
        this.maxClueDelay = maxClueDelay;
    }
    public Date getCreateTime() {
    
        return createTime;
    }
    public void setCreateTime(Date createTime) {
    
        this.createTime = createTime;
    }
    public Date getUpdateTime() {
    
        return updateTime;
    }
    public void setUpdateTime(Date updateTime) {
    
        this.updateTime = updateTime;
    }
 
    public String getConsultSourceSort() {
		return consultSourceSort;
	}
	public void setConsultSourceSort(String consultSourceSort) {
		this.consultSourceSort = consultSourceSort;
	}
	
	public Integer getAttendClassMsg() {
    
        return attendClassMsg;
    }
    public void setAttendClassMsg(Integer attendClassMsg) {
    
        this.attendClassMsg = attendClassMsg;
    }
    public Integer getSignupMsg() {
    
        return signupMsg;
    }
    public void setSignupMsg(Integer signupMsg) {
    
        this.signupMsg = signupMsg;
    }
    public Integer getSigninMsg() {
    
        return signinMsg;
    }
    public void setSigninMsg(Integer signinMsg) {
    
        this.signinMsg = signinMsg;
    }
    public Integer getEvaluateMsg() {
    
        return evaluateMsg;
    }
    public void setEvaluateMsg(Integer evaluateMsg) {
    
        this.evaluateMsg = evaluateMsg;
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

    