/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

/**
 * @title TXCommonRule
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */

@Entity
@Table(catalog = "yunying", name = "tx_common_rule")
public class TXCommonRule {
    @Id
    @GeneratedValue
    private Integer id;// 天校帐号表主键
    @Column(name = "org_id")
    private Integer orgId;// 机构id，对应yunying.org_account.id
    @Column(name = "org_number")
    private Integer orgNumber;// 机构number，对应yunying.org_account.number
    @Column(name = "student_mobile_rule")
    private Integer studentMobileRule;// 学员电话号码：0-主管和员工可见 1-主管和员工不可见
    @Column(name = "call_mobile_rule")
    private Integer callMobileRule;// 主管和学员：0-可用本机和录音电话 1-仅可用录音电话 2-仅可用本地电话（免费版）
    @Column(name = "call_send_msg_rule")
    private Integer callSendMsgRule;// 0:三方通话成功之后给学员发送提醒短信 1:非
    @Column(name = "consume_rule")
    private Integer consumeRule; // 机构默认的课消规则: 采用二进制标记规则合集，转整型存储，0,"按时间课消"
                                 // 1,"按签到算课消，到课算课消"，3,"按签到算课消，到课、请假算课消"，5,"按签到算课消，到课、缺课算课消"，7,"按签到算课消，到课、请假，缺课算课消"，
    @Column(name = "create_time")
    private Date createTime;// 创建时间
    @Column(name = "update_time")
    private Date updateTime;// 最新更新时间
    @Column(name = "vip_consume_rule")
    private Integer vipConsumeRule;// 一对一默认课消规则

    public Integer getId() {

        return id;
    }

    public void setId(Integer id) {

        this.id = id;
    }

    public Integer getOrgId() {

        return orgId;
    }

    public void setOrgId(Integer orgId) {

        this.orgId = orgId;
    }

    public Integer getOrgNumber() {

        return orgNumber;
    }

    public void setOrgNumber(Integer orgNumber) {

        this.orgNumber = orgNumber;
    }

    public Integer getStudentMobileRule() {

        return studentMobileRule;
    }

    public void setStudentMobileRule(Integer studentMobileRule) {

        this.studentMobileRule = studentMobileRule;
    }

    public Integer getCallMobileRule() {

        return callMobileRule;
    }

    public void setCallMobileRule(Integer callMobileRule) {

        this.callMobileRule = callMobileRule;
    }

    public Date getCreateTime() {

        return createTime;
    }

    public void setCreateTime(Date createTime) {

        this.createTime = createTime;
    }

    public Date getUpdateTime() {

        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {

        this.updateTime = updateTime;
    }

    public Integer getConsumeRule() {

        return consumeRule;
    }

    public void setConsumeRule(Integer consumeRule) {

        this.consumeRule = consumeRule;
    }

    public Integer getVipConsumeRule() {
        return vipConsumeRule;
    }

    public void setVipConsumeRule(Integer vipConsumeRule) {
        this.vipConsumeRule = vipConsumeRule;
    }

    /**
    * @return the callSendMsgRule
    */
    
    public Integer getCallSendMsgRule() {
    
        return callSendMsgRule;
    }

    /**
     * @param callSendMsgRule the callSendMsgRule to set
     */
    
    public void setCallSendMsgRule(Integer callSendMsgRule) {
    
        this.callSendMsgRule = callSendMsgRule;
    }
    
    

}
