/**
 * 、 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.po;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgStudents
 * @desc TODO
 * @date 2015年12月3日
 */

@Entity
@Table(name = "org_students", catalog = "yunying")
public class OrgStudent extends BaseDto {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @Column(name = "student_name")
    private String name;

    @Column(name = "nick_name")
    private String nickName;

    @Column(name = "parent_name")
    private String parentName;

    @Column(name = "parent_mobile")
    private String parentMobile;

    @Column(name = "school")
    private String school;

    @Column(name = "roll_number")
    private String rollNumber;

    @Column(name = "mobile")
    private String mobile;

    @Column(name = "show_mobile")
    private String showMobile;

    @Column(name = "branch_id")
    private Long branchId;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "del_status")
    private Integer delStatus;

    @Column(name = "org_id")
    private Long orgId;

    @Column(name = "avatar")
    private Long avatar;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "source")
    private Integer source;

    @Column(name = "birthday", defaultVal = "0")
    private Date birthday;

    @Column(name = "remark")
    private String remark;
    // 微信openId
    @Column(name = "weixin")
    private String weixin;

    @Column(name = "next_remind_time", defaultVal = "0")
    private Date nextRemindTime;

    @Column(name = "qq")
    private String qq;

    @Column(name = "mail")
    private String mail;

    @Column(name = "degree_class")
    private String degreeClass;

    @Column(name = "address")
    private String address;

    // 父亲职业
    @Column(name = "father_occupation")
    private String fatherOccupation;

    // 母亲职业
    @Column(name = "mather_occupation")
    private String matherOccupation;

    // 咨询状态（0，未发生过咨询；1，发生过咨询）
    @Column(name = "advisory_status")
    private Integer advisoryStatus;

    // 学生来源：跟谁学、微信 etc.
    @Column(name = "origin")
    private Integer origin;

    @Column(name = "pinyin")
    private String pinyin;

    // 纬度
    @Column(name = "latitude")
    private Double latitude;

    // 经度
    @Column(name = "longitude")
    private Double longitude;

    // 用户居住区域对应areaId
    @Column(name = "area_id")
    private Long areaId;

    @Column(name = "gender")
    private Integer gender;

    @Column(name = "relationship")
    private Integer relationship;

    @Column(name = "lesson_status")
    private Integer lessonStatus;// 排课状态

    @Column(name = "add_cascade_id")
    private Integer addCascadeId;// 学员添加人

    @Column(name = "custom_search_value")
    private String customSearchValue;//自定义属性的搜索
    
    @Column(name = "pwd")
    private String pwd;
    // 微信号
    @Column(name = "wechat")
    private String wechat;
    @Column(name = "enable_status")
    private Integer enableStatus;

    public void nullToEmpty() {
        // if(this.mail==null){
        // this.mail = "";
        // }
        // if(this.fatherOccupation==null){
        // this.fatherOccupation = "";
        // }
        // if(this.matherOccupation==null){
        // this.matherOccupation = "";
        // }
        // if(this.origin==null){
        // this.origin = 0;
        // }
        // if(this.gender==null){
        // this.gender = -1;
        // }
        // if(this.school==null){
        // this.school = "";
        // }
        // if(this.gender==null){
        // this.gender = -1;
        // }
        // if(this.relationship==null){
        // this.relationship = -1;
        // }
    }

    // 获取学员手机号时优先获取show_mobile，若无则获取mobile
    public String getStudentMobile() {
        if (org.apache.commons.lang3.StringUtils.isNoneBlank(showMobile)) {
            return this.showMobile;
        } else {
            return this.mobile;
        }
    }

    /**
     * @return the id
     */

    public Long studentId() {

        return id;
    }

    public Long getId() {

        return id;
    }

    /**
     * @param id the id to set
     */

    public void setId(Long id) {

        this.id = id;
    }

    /**
     * @return the name
     */

    public String getName() {

        return name;
    }

    /**
     * @param name the name to set
     */

    public void setName(String name) {
        this.name = name;
        if (StringUtils.isNotBlank(name)) {
            this.pinyin = HanZiPinYinUtils.getLowerCasePinYin(name);
        } else {
            this.pinyin = "";
        }
    }

    /**
     * @return the nickName
     */

    public String getNickName() {

        return nickName;
    }

    /**
     * @param nickName the nickName to set
     */

    public void setNickName(String nickName) {

        this.nickName = nickName;
    }

    /**
     * @return the parentName
     */

    public String getParentName() {

        return parentName;
    }

    /**
     * @param parentName the parentName to set
     */

    public void setParentName(String parentName) {

        this.parentName = parentName;
    }

    /**
     * @return the parentMobile
     */

    public String getParentMobile() {

        return parentMobile;
    }

    /**
     * @param parentMobile the parentMobile to set
     */

    public void setParentMobile(String parentMobile) {

        this.parentMobile = parentMobile;
    }

    /**
     * @return the school
     */

    public String getSchool() {

        return school;
    }

    /**
     * @param school the school to set
     */

    public void setSchool(String school) {

        this.school = school;
    }

    /**
     * @return the rollNumber
     */

    public String getRollNumber() {

        return rollNumber;
    }

    /**
     * @param rollNumber the rollNumber to set
     */

    public void setRollNumber(String rollNumber) {

        this.rollNumber = rollNumber;
    }

    /**
     * @return the mobile
     */

    public String getMobile() {

        return mobile;
    }

    /**
     * @param mobile the mobile to set
     */

    public void setMobile(String mobile) {

        this.mobile = mobile;
    }

    /**
     * @return the showMobile
     */

    public String getShowMobile() {

        return showMobile;
    }

    /**
     * @param showMobile the showMobile to set
     */

    public void setShowMobile(String showMobile) {

        this.showMobile = showMobile;
    }

    /**
     * @return the branchId
     */

    public Long getBranchId() {

        return branchId;
    }

    /**
     * @param branchId the branchId to set
     */

    public void setBranchId(Long branchId) {

        this.branchId = branchId;
    }

    /**
     * @return the createTime
     */

    public Date getCreateTime() {

        return createTime;
    }

    /**
     * @param createTime the createTime to set
     */

    public void setCreateTime(Date createTime) {

        this.createTime = createTime;
    }

    /**
     * @return the updateTime
     */

    public Date getUpdateTime() {

        return updateTime;
    }

    /**
     * @param updateTime the updateTime to set
     */

    public void setUpdateTime(Date updateTime) {

        this.updateTime = updateTime;
    }

    /**
     * @return the delStatus
     */

    public Integer getDelStatus() {

        return delStatus;
    }

    /**
     * @param delStatus the delStatus to set
     */

    public void setDelStatus(Integer delStatus) {

        this.delStatus = delStatus;
    }

    /**
     * @return the orgId
     */

    public Long getOrgId() {

        return orgId;
    }

    /**
     * @param orgId the orgId to set
     */

    public void setOrgId(Long orgId) {

        this.orgId = orgId;
    }

    /**
     * @return the avatar
     */

    public Long getAvatar() {

        return avatar;
    }

    /**
     * @param avatar the avatar to set
     */

    public void setAvatar(Long avatar) {

        this.avatar = avatar;
    }

    /**
     * @return the userId
     */

    public Long getUserId() {

        return userId;
    }

    /**
     * @param userId the userId to set
     */

    public void setUserId(Long userId) {

        this.userId = userId;
    }

    /**
     * @return the source
     */

    public Integer getSource() {

        return source;
    }

    /**
     * @param source the source to set
     */

    public void setSource(Integer source) {

        this.source = source;
    }

    /**
     * @return the birthday
     */

    public Date getBirthday() {

        return birthday;
    }

    /**
     * @param birthday the birthday to set
     */

    public void setBirthday(Date birthday) {

        this.birthday = birthday;
    }

    /**
     * @return the remark
     */

    public String getRemark() {

        return remark;
    }

    /**
     * @param remark the remark to set
     */

    public void setRemark(String remark) {

        this.remark = remark;
    }

    /**
     * @return the weixin
     */

    public String getWeixin() {

        return weixin;
    }

    /**
     * @param weixin the weixin to set
     */

    public void setWeixin(String weixin) {

        this.weixin = weixin;
    }

    /**
     * @return the nextRemindTime
     */

    public Date getNextRemindTime() {

        return nextRemindTime;
    }

    /**
     * @param nextRemindTime the nextRemindTime to set
     */

    public void setNextRemindTime(Date nextRemindTime) {

        this.nextRemindTime = nextRemindTime;
    }

    /**
     * @return the qq
     */

    public String getQq() {

        return qq;
    }

    /**
     * @param qq the qq to set
     */

    public void setQq(String qq) {

        this.qq = qq;
    }

    /**
     * @return the mail
     */

    public String getMail() {

        return mail;
    }

    /**
     * @param mail the mail to set
     */

    public void setMail(String mail) {

        this.mail = mail;
    }

    /**
     * @return the degreeClass
     */

    public String getDegreeClass() {

        return degreeClass;
    }

    /**
     * @param degreeClass the degreeClass to set
     */

    public void setDegreeClass(String degreeClass) {

        this.degreeClass = degreeClass;
    }

    /**
     * @return the address
     */

    public String getAddress() {

        return address;
    }

    /**
     * @param address the address to set
     */

    public void setAddress(String address) {

        this.address = address;
    }

    /**
     * @return the fatherOccupation
     */

    public String getFatherOccupation() {

        return fatherOccupation;
    }

    /**
     * @param fatherOccupation the fatherOccupation to set
     */

    public void setFatherOccupation(String fatherOccupation) {

        this.fatherOccupation = fatherOccupation;
    }

    /**
     * @return the matherOccupation
     */

    public String getMatherOccupation() {

        return matherOccupation;
    }

    /**
     * @param matherOccupation the matherOccupation to set
     */

    public void setMatherOccupation(String matherOccupation) {

        this.matherOccupation = matherOccupation;
    }

    /**
     * @return the advisoryStatus
     */

    public Integer getAdvisoryStatus() {

        return advisoryStatus;
    }

    /**
     * @param advisoryStatus the advisoryStatus to set
     */

    public void setAdvisoryStatus(Integer advisoryStatus) {

        this.advisoryStatus = advisoryStatus;
    }

    /**
     * @return the origin
     */

    public Integer getOrigin() {

        return origin;
    }

    /**
     * @param origin the origin to set
     */

    public void setOrigin(Integer origin) {

        this.origin = origin;
    }

    /**
     * @return the pinyin
     */

    public String getPinyin() {

        return pinyin;
    }

    /**
     * @param pinyin the pinyin to set
     */

    public void setPinyin(String pinyin) {

        this.pinyin = pinyin;
    }

    public Integer getAddCascadeId() {
        return addCascadeId;
    }

    public void setAddCascadeId(Integer addCascadeId) {
        this.addCascadeId = addCascadeId;
    }

    public Integer getLessonStatus() {
        return lessonStatus;
    }

    public void setLessonStatus(Integer lessonStatus) {
        this.lessonStatus = lessonStatus;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Integer getRelationship() {
        return relationship;
    }

    public void setRelationship(Integer relationship) {
        this.relationship = relationship;
    }

    public String getCustomSearchValue() {
        return customSearchValue;
    }

    public void setCustomSearchValue(String customSearchValue) {
        this.customSearchValue = customSearchValue;
    }
    
    public String getPwd() {
        return pwd;
    }
    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
    public String getWechat() {
        return this.wechat;
    }
    public void setWechat(String wechat) {
        this.wechat = wechat;
    }
    public Integer getEnableStatus() {
        return this.enableStatus;
    }
    public void setEnableStatus(Integer status) {
        this.enableStatus = status;
    }

    public Map<String,String> toSolrMap() throws IllegalArgumentException, IllegalAccessException{
    	Map<String,String> map = new HashMap<String,String>();
    	
        Class classObj = this.getClass();  
        Field[]  fields = classObj.getDeclaredFields();
        Field field = null;
        Column column = null;

        for (int i = 0; i < fields.length; i++) {
            field = fields[i];
            column = field.getAnnotation(Column.class);// 得到属性上的注解
            // log.info("####### "+i +" "+field.getName()+" "+column+" "+field.get(this) );
            if (column != null) {
                map.put(column.name().toUpperCase(), objToSolrStr(field.get(this)));
            }
        }

        return map;
    }

    public String getNotEmptyName() {
        String name = this.getName();
        name = GenericsUtils.isNullOrEmpty(name) ? this.getNickName() : name;
        name = GenericsUtils.isNullOrEmpty(name) ? this.getMobile() : name;
        return name;
    }

    String objToSolrStr(Object obj) {
        String str = null;

        if (obj instanceof Date) {
            if (obj == null) {
                str = "0000-00-00 00:00:00";
            } else {
                str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj);
            }
        } else {
            if (obj != null) {
                str = obj.toString();
            }
        }
        return str;
    }

    public static void main(String[] args) {
        Long dateTime = 0l;

        Date date = new Date(dateTime);
        String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        System.out.println(str);
    }
}
