package com.baijia.tianxiao.dal.org.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @title : OrgBranchs
 * @description :
 * @author : zhenyujian
 * @date : 2015年12月4日 下午5:34:15
 */
@Entity
@Table(name = "org_branchs", catalog = "yunying")
@Data
public class OrgBranchs {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "org_id")
    private Integer orgId; // 机构id

    @Column(name = "branch_name")
    private String branchName; // 分支机构名称

    @Column(name = "province")
    private String province; // 省/市

    @Column(name = "district")
    private String district; // 区

    @Column(name = "county")
    private String county; // 县

    @Column(name = "address")
    private String address; // 具体地址

    @Column(name = "create_time")
    private Date createTime; // 创建时间

    @Column(name = "update_time")
    private Date updateTime; // 更新时间

    @Column(name = "auditstatus")
    private int auditStatus;// 审核状态

    @Column(name = "reason")
    private String reason;

    @Column(name = "other")
    private String other;

    @Column(name = "isdel")
    private int isdel;// 是否删除：0：删除，1：未删除，如果审核不通过也认为是删除状态

    @Column(name = "longitude")
    private String longitude;// 经度

    @Column(name = "latitude")
    private String latitude;// 维度

    @Column(name = "area_id")
    private Long areaId;// 机构校区id

    @Column(name = "business")
    private String business;

}
