package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.WxStudentExtDao;
import com.baijia.tianxiao.dal.org.po.WxStudentExt;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.springframework.stereotype.Repository;

/**
 * Created by wangsixia on 2017/1/20.
 */
@Repository
public class WxStudentExtDaoImpl extends JdbcTemplateDaoSupport<WxStudentExt> implements WxStudentExtDao {

    @Override
    public WxStudentExt getByStudentId(Long orgId, Long studentId, String...queryProps) {
        SingleSqlBuilder<WxStudentExt> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("studentId", studentId);
        return uniqueResult(builder);
    }

    @Override
    public WxStudentExt getByUserId(Long orgId, Long userId, String...queryProps) {
        SingleSqlBuilder<WxStudentExt> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("userId", userId);
        return uniqueResult(builder);
    }
}
