/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.TXSaleClueRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
/**
 * @title TXSaleClueRuleDaoImpl
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */
    
@Repository
public class TXSaleClueRuleDaoImpl extends JdbcTemplateDaoSupport<TXSaleClueRule> implements TXSaleClueRuleDao {

    /**
     * @param entityClass
     */
    public TXSaleClueRuleDaoImpl() {
        super(TXSaleClueRule.class);
    }

    @Override
    public TXSaleClueRule getByOrgId(Integer orgId) {
        SingleSqlBuilder<TXSaleClueRule> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        return uniqueResult(builder);
    }
    
    @Override
    public List<TXSaleClueRule> queryByOrgIds(Collection<Integer> orgIds, final String... properties) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }

        ListBatchQueryTemplate<Integer, TXSaleClueRule> queryTemplate = new ListBatchQueryTemplate<>();

        return queryTemplate.batchQuery(orgIds, new BatchQueryCallback<Integer, List<TXSaleClueRule>>() {
            @Override
            public List<TXSaleClueRule> doQuery(Collection<Integer> querySet) {
                SingleSqlBuilder<TXSaleClueRule> builder = createSqlBuilder(properties);
                builder.in("orgId", querySet);
                return queryList(builder);
            }
        });
    }

}
