/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title TXCampusAccountDaoImpl
 * @desc TODO
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */
@Slf4j
@Repository
public class TXAccountDaoImpl extends JdbcTemplateDaoSupport<TXAccount> implements TXAccountDao {

    /**
     * @param
     */
    public TXAccountDaoImpl() {
        super(TXAccount.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.org.dao.TXCampusAccountDao#getByOrgId(java.lang.Integer)
     */
    @Override
    public TXAccount getByOrgId(Integer orgId, Integer status, String...props) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder(props);
        builder.eq("orgId", orgId);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        if (null != status) {
            builder.eq("status", status);
        }
        return uniqueResult(builder);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.org.dao.TXAccountDao#getByIdAndOrgId(java.lang.Integer, java.lang.Integer)
     */

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("id", id);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TXAccountStatus.VALID.getCode());
        return uniqueResult(builder);
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {

        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.eq("orgNumber", orgNumber);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        return uniqueResult(builder);

    }

    @Override
    public Map<Long, TXAccount> getAccountTypeMap(Collection<Long> orgIds) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.in("orgId", orgIds);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TXAccountStatus.VALID.getCode());
        List<TXAccount> txAccontList = queryList(builder);
        Map<Long, TXAccount> txAccountMap = new HashMap<>();
        if (txAccontList != null && txAccontList.size() > 0) {
            for (TXAccount txAccount : txAccontList) {
                txAccountMap.put(txAccount.getOrgId().longValue(), txAccount);
            }
        }

        return txAccountMap;
    }

    @Override
    public void findAndUpdateInfoFillStatus(Integer orgId) {
        TXAccount tXAccount = findTxAccountForUpdate(orgId, 0);
        if (tXAccount != null) {
            tXAccount.setInfoFillStatus(1);
            this.update(tXAccount, "infoFillStatus");
        }
    }

    @Override
    public TXAccount saveOrUpdateStartUpPageInfo(Integer orgId, String initOrgName, String orgSlogan, String orgLogo) {
        TXAccount tXAccount = findTxAccountForUpdate(orgId);
        log.info("tXAccount ======== is :{} ", tXAccount);
        if (tXAccount != null) {
            tXAccount.setOrgSlogan(orgSlogan);
            tXAccount.setOrgLogo(orgLogo);
            tXAccount.setInitOrgName(initOrgName);
            tXAccount.setInfoFillStatus(2);
            this.update(tXAccount, "infoFillStatus", "initOrgName", "orgSlogan", "orgLogo");
        }
        return tXAccount;
    }

    static List<Integer> normalAccountStatus = new ArrayList<>();
    static {
        normalAccountStatus.add(1);
    }

    /**
     * @param orgId
     * @return
     */
    private TXAccount findTxAccountForUpdate(Integer orgId, Integer...infoFillStatus) {
        String sql =
            "select info_fill_status as infoFillStatus ,id  from yunying.tx_account where org_id =:orgId and status in(:accountStatus) and info_fill_status in(:status) for update";
        Map<String, Object> paramMap = Maps.newHashMap();
        if (GenericsUtils.isNullOrEmpty(infoFillStatus)) {
            infoFillStatus = new Integer[] { 0, 1, 2 };
        }
        paramMap.put("orgId", orgId);
        paramMap.put("accountStatus", normalAccountStatus);
        paramMap.put("status", Arrays.<Integer> asList(infoFillStatus));
        final List<TXAccount> tXAccounts = Lists.newArrayList();

        log.info("paramMap is :{} ", paramMap);
        this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<TXAccount>() {
            @Override
            public TXAccount extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    log.info("rs is :{} ", rs);
                    TXAccount tx = new TXAccount();
                    tx.setId(rs.getInt("id"));
                    tx.setInfoFillStatus(rs.getInt("infoFillStatus"));
                    tXAccounts.add(tx);
                }
                return null;
            }
        });
        log.info("************tXAccounts is :{} ", tXAccounts);
        if (GenericsUtils.isNullOrEmpty(tXAccounts)) {
            return null;
        }
        return tXAccounts.get(0);
    }

    @Override
    public Map<Integer, TXAccount> listAllTxAccountByIds(Collection<Integer> orgIds) {
        SingleSqlBuilder<TXAccount> builder = createSqlBuilder();
        builder.in("orgId", orgIds);
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.eq("status", TXAccountStatus.VALID.getCode());
        List<TXAccount> queryList = this.queryList(builder);
        Map<Integer, TXAccount> retMap = Maps.newHashMap();
        if (GenericsUtils.notNullAndEmpty(queryList)) {
            for (TXAccount oa : queryList) {
                retMap.put(oa.getId(), oa);
            }
        }
        return retMap;
    }

}
