/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * @title OrgHomepageTemplateDaoImpl
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月5日
 * @version 1.0
 */
@Repository("tianxiao_dal_yunying_orgHomepageTemplateDao")
public class OrgHomepageTemplateDaoImpl extends JdbcTemplateDaoSupport<OrgHomepageTemplate>
    implements OrgHomepageTemplateDao {

    /**
     */
    public OrgHomepageTemplateDaoImpl() {
        super(OrgHomepageTemplate.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao#getDefaultTemplate()
     */
    @Override
    public OrgHomepageTemplate getTemplate(int isDefault) {
        SingleSqlBuilder<OrgHomepageTemplate> builder = createSqlBuilder();
        builder.eq("isDefault", isDefault);
        return uniqueResult(builder);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao#getAllValidTemplate()
     */
    @Override
    public List<OrgHomepageTemplate> getAllValidTemplate() {
        SingleSqlBuilder<OrgHomepageTemplate> builder = createSqlBuilder();
        builder.eq("status", 0);
        builder.desc("displayOrder");
        return queryList(builder);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao#updateTemplate(java.lang.String, java.lang.String)
     */
    @Override
    public void updateTemplate(String scheme, String content) {
        String sql = "update yunying.tx_homepage_template set content=? where template_name=?";
        this.getNamedJdbcTemplate().getJdbcOperations().update(sql, new Object[] { content, scheme });
    }
}
