
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 机构主页个性化模板dao实现类
 *
 * @author zhangbing
 * @version 1.0
 * @title OrgHomepageTemplateDaoImpl
 * @desc TODO
 * @date 2015年12月3日
 */
@Repository("tianxiao_dal_yunying_orgHomepageConfigDao")
public class OrgHomepageConfigDaoImpl extends JdbcTemplateDaoSupport<OrgHomepageConfig>
        implements OrgHomepageConfigDao {

    /**
     */
    public OrgHomepageConfigDaoImpl() {
        super(OrgHomepageConfig.class);
    }

    /**
     * (non-Javadoc)
     *
     * @see com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao#getTemplateConf(java.lang.Integer, java.lang.Integer)
     */
    @Override
    public OrgHomepageConfig getTemplateConf(Integer orgId, Integer templateId) {
        try {
            String sql = "select * from yunying.tx_homepage_conf where org_id=? and template_id=?";
            return this.getNamedJdbcTemplate().getJdbcOperations().queryForObject(sql,
                    new Object[]{orgId, templateId}, BeanPropertyRowMapper.newInstance(OrgHomepageConfig.class));
        } catch (Exception e) {
            return null;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao#getTemplateConfByStatus(java.lang.Integer,
     * java.lang.Integer)
     */
    @Override
    public OrgHomepageConfig getTemplateConfByStatus(Integer orgId, Integer status) {
        SingleSqlBuilder<OrgHomepageConfig> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("status", status);
        builder.desc("updateTime");
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }

    @Override
    public void deleteAllConf() {
        String sql = "delete from yunying.tx_homepage_conf";
        this.getNamedJdbcTemplate().getJdbcOperations().execute(sql);
    }

    @Override
    public Set<Long> getUseTemplateOrgIds(List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql =
                "select count(1) as count,org_id from yunying.tx_homepage_conf where status=0 and org_id in (:orgIds) GROUP BY org_id";
//        if (startTime != null && endTime != null) {
//            sql += " and create_time between :startTime and :endTime";
//            param.put("startTime", startTime);
//            param.put("endTime", endTime);
//        }
//        sql += " GROUP BY org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Set<Long>>() {
            @Override
            public Set<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Set<Long> set = new HashSet<Long>();
                while (rs.next()) {
                    set.add(rs.getLong("org_id"));
                }
                return set;
            }
        });
    }

    @Override
    public List<Long> getAllUsingConf() {
        SingleSqlBuilder<OrgHomepageConfig> builder = createSqlBuilder();
        builder.select("orgId");
        builder.eq("status", 0);
        builder.group("orgId");
        return queryForList(builder, Long.class);
    }
}
