
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.commons.OrgStatisticsExtractor;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsgReceiver;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title OrgGroupMsgReceivedDaoImpl
 * @desc TODO
 * @author bjhl
 * @date 2016年2月24日
 * @version 1.0
 */
@Repository
public class OrgGroupMsgReceiverDaoImpl extends JdbcTemplateDaoSupport<OrgGroupMsgReceiver>
    implements OrgGroupMsgReceiverDao {

    public OrgGroupMsgReceiverDaoImpl() {
        super(OrgGroupMsgReceiver.class);
    }

    @Override
    public List<OrgGroupMsgReceiver> queryReceivers(Long orgId, Long msgId, String...queryProps) {
        SingleSqlBuilder<OrgGroupMsgReceiver> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("msgId", msgId);
        return queryList(builder);
    }

    @Override
    public Map<Long, Integer> queryRecievedCountMap(Long orgId, Boolean viewStatus, Collection<Long> msgIds) {
        if (CollectionUtils.isEmpty(msgIds)) {
            return Maps.newHashMap();
        }
        Map<String, Object> params = Maps.newHashMap();
        StringBuffer sql = new StringBuffer();
        sql.append(
            "select received.msg_id, count(1) as num from yunying.org_group_msg_received received where received.org_id =:orgId and received.msg_id in (:msgId) ");
        if (viewStatus != null) {
            sql.append("and received.view_status =:viewStatus ");
            params.put("viewStatus", viewStatus);
        }
        sql.append("group by received.msg_id");
        params.put("orgId", orgId);
        params.put("msgId", msgIds);
        final Map<Long, Integer> result = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql.toString(), params, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                result.put(rs.getLong("msgId"), rs.getInt("num"));
            }
        });
        return result;
    }

    @Override
    public OrgGroupMsgReceiver queryReceiver(Long orgId, Long msgId, Long receiverId, String...queryProps) {
        SingleSqlBuilder<OrgGroupMsgReceiver> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("msgId", msgId);
        builder.eq("receiverId", receiverId);
        return uniqueResult(builder);
    }

    @Override
    public Map<Long, Integer> getMsgReceiverTotal(Boolean viewStatus, Date startDate, Date endDate,
        List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(1) as count,org_id from yunying.org_group_msg_receiver where org_id in (:orgIds) ";
//        if (viewStatus != null) {
//            sql += " and view_status = " + (viewStatus ? 1 : 0);
//        }
        if (startDate != null && endDate != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql += " GROUP BY org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new OrgStatisticsExtractor());
    }

    @Override
    public Map<Long, Integer> getMsgReceiverTotalByMsgId(Boolean viewStatus, List<Long> msgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("msgIds", msgIds);
        String sql = "select count(1) as count, msg_id from yunying.org_group_msg_receiver where msg_id in (:msgIds)";
        if(GenericsUtils.notNullAndEmpty(viewStatus)){
            sql += " and view_status = " + (viewStatus ? 1 : 0);
        }
        sql += " GROUP BY msg_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<>();
                while(rs.next()){
                    Long msgId = rs.getLong("msg_id");
                    Integer count = rs.getInt("count");
                    map.put(msgId, count);
                }
                return map;
            }
        });
    }

}
