
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.org.dao.impl;

import org.springframework.stereotype.Repository;
import com.baijia.tianxiao.dal.org.dao.OrgConfigDao;
import com.baijia.tianxiao.dal.org.po.OrgConfig;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * @title OrgConfigDaoImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2016年2月17日
 * @version 1.0
 */
@Repository
public class OrgConfigDaoImpl extends JdbcTemplateDaoSupport<OrgConfig> implements OrgConfigDao {

    public OrgConfigDaoImpl() {
        super(OrgConfig.class);
    }

    @Override
    public OrgConfig getOrgConfig(int number, int userRole, String tag) {
        SingleSqlBuilder<OrgConfig> builder = createSqlBuilder();
        builder.eq("userId", number);
        builder.eq("userRole", userRole);
        builder.eq("tag", tag);
        builder.desc("createTime");
        
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }

}

    