/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author caoliang
 * @version 1.0
 * @title TXCascadeCredentialDao
 * @desc TODO
 * @date 2016年5月10日
 */

public interface TXCascadeCredentialDao extends CommonDao<TXCascadeCredential> {

    TXCascadeCredential getByMobile(String mobile);

    /**
     * 获取子帐号信息
     *
     * @param credentialIds
     * @return
     */
    List<TXCascadeCredential> getTxCascadCredentialListByCredentialIds(Collection<Integer> credentialIds);

    /**
     * 获取姓名 根据cascadeId
     *
     * @param cascadeIds
     * @return
     */
    Map<Long, String> getTxCascadCredentialListByCascdeIds(Collection<Integer> cascadeIds);

    TXCascadeCredential getTXCascadeCredentialByCredentialId(Integer credentialId);

    Map<Long, String> getTxCascadCredentialNameByCascdeIds(Collection<Integer> cascadeIds);

    Map<Integer, TXCascadeCredential> getTxCascadeNameAndAvatar(Collection<Integer> cascadeIds);

    public List<TXCascadeCredential> getByCredentialIds(Collection<Integer> credentialIds, Integer delStatus);

    /**
     * 筛选班主任
     *
     * @param key： 查询字符串
     * @param cascadeId：过滤的班主任id
     * @param cascadeAccountIds：班主任id集合
     * @param pagedto：页面信息
     * @return
     */
    List<TXCascadeCredential> gueryByKey(String key, Integer cascadeId, Collection<Integer> cascadeAccountIds,
        PageDto pagedto);

    Map<Integer, TXCascadeCredential> getCredentialMap(List<Integer> credentialIds);

}
