/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title TXCampusAccountDao
 * @desc TODO
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */

public interface TXAccountDao extends CommonDao<TXAccount> {

    public TXAccount getByOrgId(Integer orgId, Integer status, String...props);

    public TXAccount getByIdAndOrgId(Integer id, Integer orgId);

    public TXAccount getByOrgNumber(Integer orgNumber);

    /**
     * 获取机构类型
     */
    Map<Long, TXAccount> getAccountTypeMap(Collection<Long> orgIds);

    /**
     * @param orgId
     */
    public void findAndUpdateInfoFillStatus(Integer orgId);

    /**
     * @param orgId
     * @param initOrgName
     * @param orgSlogan
     * @param orgLogoStorageId
     * @return
     */
    TXAccount saveOrUpdateStartUpPageInfo(Integer orgId, String initOrgName, String orgSlogan, String orgLogo);

    /**
     * @param orgIds
     * @return
     */

    public Map<Integer, TXAccount> listAllTxAccountByIds(Collection<Integer> orgIds);
}
