
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author cxm
 * @version 1.0
 * @title OrgTeacherDao
 * @desc TODO
 * @date 2016年1月8日
 */
public interface OrgTeacherDao extends CommonDao<OrgTeacher> {

    List<Long> getTeacherIds(Long orgId, Integer status);

    List<OrgTeacher> listByLastId(Long orgId, Long lastId, Integer pageSize, Boolean isInUse, Integer status,
        String...queryProps);

    List<OrgTeacher> getTeacherByOpenIdAndOrgId(Long orgId, String weixinOpenId, Integer status, String...queryProps);

    List<OrgTeacher> getTeacherByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String...queryProps);

    List<OrgTeacher> getTeacherByUserIdAndOrgId(Long orgId, Long userId, Integer status, String...queryProps);

    /**
     * 统计机构已经签约的老师
     * 
     * @param startDate
     * @param endDate
     * @param TianxiaoOrgIds
     * @return
     */
    public Map<Long, Integer> getTeacherTotalMapByOrgIds(Date startDate, Date endDate, List<Long> TianxiaoOrgIds);

    /**
     * 根据orgIds获取机构老师信息
     */
    public List<OrgTeacher> getOrgTeacherListByOrgIds(List<Long> orgIds);

    List<OrgTeacher> getTeacherByUserIdsAndOrgId(Long orgId, Collection<Long> userIds, Integer status, Boolean isInUse,
        String...queryProps);

    Map<Long, OrgTeacher> getMapByIds(Long orgId, Collection<Long> userIds, String...queryProps);

    void refreshOrgTeacher(Long orgId, Long id);

    List<OrgTeacher> getTeachersByOrgId(Long orgId, PageDto page, String...queryProp);

    public Integer getSignedTeacherCount(List<Long> orgIds);

    public Map<Integer, Integer> getSignedTeacherCountMap(List<Integer> orgIds);

    OrgTeacher getTeachersByOrgIdAndId(Long orgId, Long teacherId, PageDto pageDto);

    OrgTeacher getTeachersByUserId(Long userId);

    public List<OrgTeacher> listOpenIdNotNull(Long minId);

    void saveCdbOrgTeacher(Long userId, Long userNumber, Long orgId);

    /**
     * @param orgIds
     * @param openId
     * @return
     */
    List<OrgTeacher> findStudentWithOrgAndOpenId(List<Integer> orgIds, String openId, String...queryProps);

    /**
     * @param orgIds
     * @param mobile
     * @param string
     * @return
     */
    List<OrgTeacher> getTeachersByMobileAndOrgIds(List<Long> orgIds, String mobile, String...queryProps);

    /**
     * @param longValue
     * @param pageDto
     * @return
     */
    List<OrgTeacher> searchHasMobileAndNeedBindWithOpenId(long orgId, PageDto pageDto);

    List<Long> listTeacherUserIds(List<Long> orgIds);

    Map<Long, OrgTeacher> mapKeyUserIdVauleTeacher(List<Long> orgIds);

    Integer countTeacher(List<Long> orgIds);

    OrgTeacher getByUserId(Long userId);

    /**
     * @param orgIds
     * @return
     */
    List<OrgTeacher> getPausedOrgTeacherListByOrgIds(List<Long> orgIds);

    /**
     * @param orgId
     * @param teacherIds
     * @return
     */
    Collection<OrgTeacher> getTeachersByOrgIdAndIds(Integer orgId, Collection<Long> teacherIds);

    /**
     * @param orgId
     * @param useStatus
     * @param status
     * @param pageDto
     * @param queryProps
     * @return
     */
    List<OrgTeacher> listByPageDto(Long orgId, Integer useStatus, Integer status, PageDto pageDto, String... queryProps);

}
