/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title OrgStudentsDao
 * @desc TODO
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */
public interface OrgStudentDao extends CommonDao<OrgStudent> {

    /**
     * 根据机构id和userId查询学生信息
     * 
     * @param orgId
     * @param userId
     * @return
     */
    public OrgStudent getStudent(Long orgId, Long userId, Integer delStatus, String...queryProps);

    /**
     * 根据userId和机构orgId查询学员信息
     */
    public OrgStudent getStudentByUserId(Long orgId, Long userId, String...queryProps);

    /**
     * 查找机构学员
     * 
     * @param orgId
     * @param page
     * @param queryProps
     * @return
     */
    public List<OrgStudent> getStudents(Long orgId, String searchKey, Integer delStatus, PageDto page,
        String...queryProps);

    public List<OrgStudent> getStudents(Long orgId, List<Long> userIds, String searchKey, Integer delStatus,
        PageDto page, String...queryProps);

    List<OrgStudent> getStudentsNotInUserIds(Long orgId, Collection<Long> usrIds, String searchKey, Integer delStatus,
        PageDto page, String...queryProps);

    List<OrgStudent> getStudentsUserIdsSortedByPinyin(Long orgId, String searchKey, Integer delStatus, PageDto page);

    /**
     * 查找机构学员
     * 
     * @param orgId
     * @param queryProps
     * @return
     */
    public List<OrgStudent> getStudents(Long orgId, Collection<String> mobiles, Integer delStatus, String...queryProps);

    /**
     * 查找机构学员 慎用: page不为空时，若userIds>500，分片查询结果为多个page数据
     * 
     * @param orgId
     * @param userIds
     * @param page
     * @param queryProps
     * @return
     */
    public List<OrgStudent> getStudents(Long orgId, Collection<Long> userIds, Integer delStatus, PageDto page,
        String...queryProps);

    /**
     * 根据创建时间查找学员
     * 
     * @param createTime
     * @param page
     * @param queryProps
     * @return
     */
    public List<OrgStudent> getStudents(Date createTime, Integer delStatus, PageDto page, String...queryProps);

    /**
     * 查找指定机构下指定手机号的学生
     * 
     * @param orgId
     * @param mobile
     * @param queryProps
     * @return
     */
    public OrgStudent getStudentByMobileAndOrgId(Long orgId, String mobile, String...queryProps);

    /**
     * 查找指定机构下指定手机号的学生
     * 
     * @param orgId
     * @param mobile
     * @param queryProps
     * @return
     */
    public List<OrgStudent> getStudentByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String...queryProps);

    /**
     * 查找指定机构下指定openId的学生
     * 
     * @param orgId
     * @param queryProps
     * @return
     */
    public List<OrgStudent> getStudentByOpenIdAndOrgId(Long orgId, String weixinOpenId, String...queryProps);

    /**
     * 根据手机号查询最近的符合条件的
     * 
     * @param orgId
     * @param mobile
     * @param queryProps
     * @return
     */
    public OrgStudent getLastStudentByMobileOrParentMobile(Long orgId, String mobile, String...queryProps);

    /**
     * 根据studentId 查 userId
     */
    Long getUserId(Long studentId);

    /**
     * 根据userId 查 studentId
     */
    Long getStudentId(Long studentId);

    /**
     * 根据studentIds 查 <id,userId>
     */
    Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds);

    /**
     * 根据studentIds 查 <userId,id>
     */
    Map<Long, Long> getStudentUserIdAndIdMap(Collection<Long> studentIds);

    /**
     * 根据studentIds 查 学生名
     */
    Map<Long, String> getStudentNameMap(Collection<Long> studentIds);

    /**
     * 根据userIds 查 学生信息
     */
    Map<Long, OrgStudent> getStudentMap(Collection<Long> userIds, final Long orgId, String...propes);

    /**
     * 根据userIds 查 studentIds
     */
    Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId);

    List<OrgStudent> getStudentByIds(final Long orgId, Collection<Long> studentIds, final String...propes);

    List<OrgStudent> getStudentByUserIds(final Long orgId, Collection<Long> userIds, final String...propes);

    List<OrgStudent> getStudentByUserIdsAndDelStatus(final Long orgId, Collection<Long> userIds,
        final Integer delStatus, final String...propes);

    /**
     * 获取需要提醒的用户信息
     * 
     * @Author liuxiaopeng
     * @return
     */
    List<OrgStudent> getUserByRemindTime(Date startTime);

    /**
     * 获取需要提醒的用户信息
     * 
     * @Author liuxiaopeng
     * @return
     */
    List<OrgStudent> getUserByRemindTime(Date startTime, Date endTime);

    List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value);

    /**
     * 根据机构ids和userIds获取学员信息
     * 
     * @param orgIds
     * @param userIds
     * @return
     */
    List<OrgStudent> getStudentsByUserIdsAndOrgIds(Collection<Long> orgIds, Collection<Long> userIds);

    /**
     * 根据学生手机号码和姓名查询学生(目前逻辑是：如果student_name不为空，mobile_studentName是唯一索引)
     * 
     * @param orgId
     * @param mobile
     * @param studentName
     * @return
     */
    OrgStudent getStudentByMobileAndName(Long orgId, String mobile, String studentName);

    public List<OrgStudent> getStudentsByMobileAndName(Long orgId, String mobile, String studentName);

    List<OrgStudent> getStudentsLikeMobileAndName(Long orgId, String mobile, String studentName, String...props);

    /**
     * 根据指定属性的key-value分页查询学员档案信息
     * 
     * @param pageDto
     * @return
     */
    List<OrgStudent> searchStudentByCustomParam(long orgId, AutoMatchQueryRequest params, Collection<Long> inStudentIds,
        PageDto pageDto);

    List<OrgStudent> getStudentId(Long orgId, String mobile, Integer delStatus, String name, String...propes);

    /**
     * 查询机构正式学员数量
     */
    public Map<Long, Integer> getStudentTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds);

    /**
     * 查询某状态下学员的总是
     * 
     * @param TianxiaoOrgIds
     * @param lessonStatus 参考StudentLessonStatus 如果不传 则查询所有正式学员
     * @return
     */
    public Map<Long, Integer> getStudentTotalByStatus(List<Long> TianxiaoOrgIds, Integer lessonStatus);

    /**
     * 根据机构id获取其和正式学员userIds映射关系
     */
    public Map<Long, List<Long>> getUserIdMapByOrgIds(List<Long> TianxiaoOrgIds);

    /**
     * 按日期获取正式学员数量
     */
    public Map<String, Integer> getStudentTotalMap(Date startDate, Date endDate, List<Long> TianxiaoOrgIds);

    /**
     * 查询绑定微信公众号学生数
     */
    public Map<Long, Integer> getOrgWechatAuthorizerOfStudentTotal(List<Long> TianxiaoOrgIds);

    void refreshOrgStudent(Long orgId, Long id);

    List<OrgStudent> getStudentsByPage(PageDto pageDto);

    public List<OrgStudent> getStudentByOrgIdAndCourseName(Long orgId, String searchKey);

    public List<OrgStudent> getStudentList(Long orgId, String searchKey, Integer delStatus, PageDto page,
        String...queryProps);

    public List<OrgStudent> getPageStudentByUserIds(final Long orgId, Collection<Long> userIds,
        Collection<Long> inStudentIds, final PageDto pageDto);

    /**
     * 根据userIds查询学生
     */
    public Map<Long, OrgStudent> getOrgStudentMapByUserIds(Collection<Long> userIds);

    public Integer getStudentSum(Integer orgId);

    /**
     * @param orgId
     * @param studentIds
     * @param isAll
     * @param pageDto
     */
    public List<OrgStudent> searchStudent(Long orgId, Collection<? extends Long> studentIds, boolean isAll,
        PageDto pageDto);

    public Integer getStudentSum(List<Long> orgIds);

    public List<OrgStudent> getStudentByUserId(Long userId, Integer delStatus);

    public Integer getStudentCountByTime(Date startTime, Date endTime, Long orgId);

    public void batchUpdateStudentStatus(long orgId, Collection<Long> studentIds, int status);

    public void batchUpdateStudentToStudying(long orgId, Collection<Long> userIds);

    public void updateStudentStatusByOrgId(Long orgId, int status);

    public Map<Integer, Integer> getStudentCountMap(List<Integer> orgIds);

    public List<OrgStudent> getOrgStudents(Long orgId, List<String> mobiles);

    public OrgStudent getStudent(Long orgId, String mobile, Long userId);

    /**
     * 根据学生的排课信息统计学生数
     */
    public Map<Integer, Integer> getStatisticsByLessonStatus(int orgId, Collection<Long> studentIds);

    public List<OrgStudent> getStudentList(int orgId, List<Integer> lessonStatus, Collection<Long> addCascadeIds,
        Collection<Long> studentIds, boolean asc, final PageDto dto);

    public List<Long> getStudentIdsByAdder(int cascadeId, long orgId);

    public List<OrgStudent> listPinYinNull(Long maxId, Integer size);

    public void replacePortrait(String oldUrl, String newUrl);

    /**
     * 根据学生状态( STUDYING(1,"在读学员"), PAST(2,"往期学员"), ALL(0,"全部学员"), TO_CHARGE(3,"待续费学员"); )统计学生数
     */
    public Map<Integer, Integer> getStatisticsDayByLessonStatus(int status, List<Integer> orgIds);

    /**
     * @return
     */
    public void updateNextRemindTime(Long studentId);

    /**
     * 根据姓名/手机号模糊检索学员
     * 
     * @param param 学员姓名或手机号
     * @return
     */
    public List<OrgStudent> fuzzySearchStudents(Long orgId, String param, PageDto page, String...queryProps);

    Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId, boolean needFilterDel);

    List<OrgStudent> listOpenIdNotNull(Long minId);

    public Integer countStudentsByTime(Long orgId, Date startTime, Date endTime);

    /*
     * public Map<Long, List<String>> getStudentMapBycourseIds(Collection<Long> courseIds, final int status, final
     * String...queryProps);
     */

    /**
     * @param intValue
     * @param needDataAuthority
     * @param studentIds
     * @param cascadeId
     * @return
     */
    public Map<Integer, Integer> getStatisticsByLessonStatus(int intValue, boolean needDataAuthority,
        List<Long> studentIds, Integer cascadeId);

    public Map<String, OrgStudent> getStudentByOpenIdAndOrgIdMap(Integer orgId, List<String> weixinOpenId);

    Map<String, OrgStudent> getStudentHadMobileByOpenIdAndOrgIdMap(Integer orgId, List<String> weixinOpenId);

    public int getStudentHadMobileByOpenIdAndOrgIdCount(Integer orgId, List<String> weixinOpenId);

    public int getStudentByOpenIdAndOrgIdMapCount(Integer orgId, List<String> weixinOpenId);

    /**
     * 
     * @param orgIds
     * @param openId
     * @return
     */
    public List<OrgStudent> findStudentWithOrgAndOpenId(List<Integer> orgIds, String openId, String...queryProps);

    public int countBySource(Long orgId, Long sourceId);

    Map<Long, String> mapIdVsName(Collection<Long> ids);

    /**
     * @param orgIds
     * @param mobile
     * @param queryProps
     * @return
     */
    List<OrgStudent> getStudentsByMobileAndOrgIds(Collection<Long> orgIds, String mobile, String...queryProps);

    /**
     * @param orgId
     * @param pageDto
     * @return
     */
    List<OrgStudent> searchHasMobileAndNeedBindWithOpenId(Long orgId, PageDto pageDto);

    Map<Long, OrgStudent> mapKeyUserId(Long orgId, String keyword);

    List<Long> listUserId(Long orgId, String keyword);

    public Map<String, OrgStudent> getStudentByMobilesAndOrgIdMap(Integer orgId, List<String> mobiles);

    /**
     * 网校学员列表
     * @param orgId
     * @param key
     * @param userIds
     * @param enableStatus
     * @param lessonStatus
     * @param start
     * @param end
     * @param pageDto
     * @return
     */
    List<OrgStudent> getWxListByParam(Long orgId, String key, Collection<Long> userIds, Integer enableStatus, Collection<Integer> lessonStatus, Date start, Date end, PageDto pageDto);

    /**
     * 统计学员报表<日期,数量>
     * @param orgId
     * @param start
     * @param end
     * @return
     */
    Map<String, Integer> getStudentCount(Long orgId, Date start, Date end);

    List<Long> getDelUserIds(Long orgId);

    
    List<OrgStudent> listStudentsOrderByName(Collection<Long> userIds,PageDto pageDto);


    /**
     * @param orgIds
     * @return
     */
    Map<Integer, Integer> getStudentCountMapByStatus(List<Integer> orgIds, List<Integer> lessonStatus);

}
