/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface OrgInfoDao extends CommonDao<OrgInfo> {

    OrgInfo getOrgInfo(Integer orgId, String... queryProps);

    Map<Integer, Long> getAreaMap(Collection<Integer> orgIds);

    OrgInfo getByExtension(String extension, String... properties);

    String getOrgNameByOrgId(Integer orgId);

    boolean updateMarkingStatusByOrgId(Integer orgId, Integer markingStatus);

    boolean updateTeacherSigninByOrgId(Long orgId, Integer signStatus);

    String getOrgShortNameByOrgId(Integer orgId);

    List<Integer> getOrgIdByOrgName(String name);

    List<OrgInfo> getOrgInfoByNameAndAreaId(String name, Long areaId, String... properties);

    List<OrgInfo> getOrgInfos(Collection<Integer> orgIds, String... properties);

    List<OrgInfo> getOrgInfos(Collection<Integer> orgIds, Long areaId, String... properties);

    List<OrgInfo> getOrgInfosByExtentions(Collection<String> extensions, String... properties);

    /**
     * 得到每个机构相对应的分机号码
     *
     * @param orgIds
     * @return
     */
    Map<Long, String> getExtentionsByOrgIds(List<Long> orgIds);

    OrgBaseInfoDto getBaseInfo(int orgId);

    /**
     * 获取指定机构的信息
     * @param orgId：机构id
     * @param key：检索字符串
     * @return
     */
	OrgInfo queryOrgInfo(int orgId, String key);
	
	Map<Integer, OrgInfo> getOrgInfoMap(Collection<Integer> orgIds, String... properties);

}