
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgGroupMsgReceiver;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title OrgGroupMsgReceivedDao
 * @desc TODO
 * @author bjhl
 * @date 2016年2月24日
 * @version 1.0
 */

public interface OrgGroupMsgReceiverDao extends CommonDao<OrgGroupMsgReceiver> {

    public OrgGroupMsgReceiver queryReceiver(Long orgId, Long msgId, Long receiverId, String...queryPros);

    public List<OrgGroupMsgReceiver> queryReceivers(Long orgId, Long msgId, String...queryPros);

    public Map<Long, Integer> queryRecievedCountMap(Long orgId, Boolean viewStatus, Collection<Long> msgIds);

    /**
     * 统计信息接受人数
     * 
     * @param orgId
     * @param viewStatus 消息查看状态 0：未查看 1：查看
     * @param startDate startDate和endDate不为null,则查看一段时间范围内信息接受人数
     * @param endDate
     * @return
     */
    public Map<Long,Integer> getMsgReceiverTotal(Boolean viewStatus, Date startDate, Date endDate, List<Long> TianxiaoOrgIds);
    
    /**
     * 根据msgIds 统计机构信息接收人数
     */
    public Map<Long, Integer> getMsgReceiverTotalByMsgId(Boolean viewStatus, List<Long> msgIds);

}
