
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title OrgGroupMsgDao
 * @desc TODO
 * @author shanyu
 * @date 2016年2月24日
 * @version 1.0
 */

public interface OrgGroupMsgDao extends CommonDao<OrgGroupMsg> {

    List<OrgGroupMsg> getByOrgId(Long orgId, PageDto page, String...queryPros);

    /**
     * 统计群发消息数量
     * @param startDate 如果startDate和endDate为Null,则统计所有群发消息
     * @param endDate
     * @return
     */
    Map<Long,Integer> getOrgGroupMsgTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds);
    
    /**
     * 统计群发消息
     */
    Map<Long, List<OrgGroupMsg>> getOrgGroupMsgMap(Date startDate, Date endDate, List<Long> TianxiaoOrgIds);

}
