/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.org.dao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title OrgAccountDao
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月2日
 * @version 1.0
 */
public interface OrgAccountDao extends CommonDao<OrgAccount> {

    // 根据机构number获取OrgAccount
    OrgAccount getAccountByNumber(Integer number, String...queryProps);

    List<OrgAccount> getAccountByNumbers(Collection<Integer> numbers, String...queryProps);

    OrgAccount getAccountById(int id, String...queryProps);

    public OrgAccount getAccountByMobile(String mobile);

    Map<Long, Long> getOrgIdsByOrgNumbers(List<Long> orgNumber);

    Map<Long, Integer> getorgNumbersByOrgIds(Collection<Long> orgIds);

    Map<Integer, Long> batchSearchOrgIds(List<Integer> orgNumbers);

    List<OrgAccount> getOrgAccountByOrgIds(Collection<Integer> orgIds);

    /**
     * @param orgIds
     * @return
     */
    Map<Integer, OrgAccount> listAllOrgAccountByIds(Collection<Integer> orgIds);

}
