
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.msg.po;

import java.util.Date;

import com.baijia.tianxiao.enums.SendMsgErrorCode;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.google.common.base.Preconditions;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @title TxSmsCount
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
@Data
@Entity(name = "tx_sms_count")
@Table(catalog = "yunying")
@Slf4j
public class TxSmsCount {

    @Id
    @GeneratedValue
    private Long id;

    @Column
    private Long orgId;

    @Column
    private int leftFreeCount;

    @Column
    private int usedFreeCount;

    @Column
    private int leftBuyCount;

    @Column
    private int usedBuyCount;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;

    public void decreaseMsgCount(int count) {
        Preconditions.checkArgument(count > 0, "count must great than 0");
        if (this.leftFreeCount > 0) {
            this.leftFreeCount -= count;
            this.usedFreeCount += count;
        } else if (this.leftBuyCount > 0) {
            this.leftFreeCount -= count;
            this.usedFreeCount += count;
        } else {
            log.warn("left msg count is out of range:{}", this);
            throw new MsgSendException(SendMsgErrorCode.NOT_SMS_COUNT);
        }
    }

}
