
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.msg.dao.impl;

import com.baijia.tianxiao.dal.commons.OrgStatisticsExtractor;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.msg.po.TxSms;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title TxSmsDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
@Repository
public class TxSmsDaoImpl extends JdbcTemplateDaoSupport<TxSms> implements TxSmsDao {
    @Override
    public Integer getTxSmsTotal(Integer orgId, Integer senderRole, Integer sendResult, String startDate,
        String endDate) {
        SingleSqlBuilder<TxSms> builder = createSqlBuilder();
        builder.eq("senderId", orgId);
        if (senderRole != null) {
            builder.eq("senderRole", senderRole);
        }
        if (sendResult != null) {
            builder.eq("sendResult", sendResult);
        }
        if (startDate != null && endDate != null) {
            builder.between("createTime", startDate, endDate);
        }
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Long, Integer> getOrgTxSmsCount(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        String sql =
            "select count(1) as count,sender_id as org_id from yunying.tx_sms where sender_role = 6 and sender_id in (:orgIds)";
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        if (startTime != null && endTime != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startTime);
            param.put("endDate", endTime);
        }
        sql += " GROUP BY sender_id";
        return this.getNamedJdbcTemplate().query(sql, param, new OrgStatisticsExtractor());
    }
}
