package com.baijia.tianxiao.dal.index.dao;

import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/7
 * Time: 下午3:20
 * To change this template use File | Settings | File Templates.
 */
public interface TxVisitorDao extends CommonDao<TxVisitor> {

    List<TxVisitor> listByTime(Date startDay, Date endDate);

    List<TxVisitor> listBeforeTime(Date thisDate);

    /**
     * 获取已经开启的体验帐号数量
     *
     * @return
     */
    Integer getActiveCount();

    /**
     * 取体验帐号详情，除前期进入系统的有重复手机号情况，第二期上线时会加上限制
     *
     * @param mobile
     * @return
     */
    List<TxVisitor> getByMobile(String mobile);

    void updateByMobile(TxVisitor txVisitor);

    void modifyPassword(String mobile, String encryptPwd);

    List<TxVisitor> releaseAccount(Date startTime, Date endDate);

    void updateStatus(int status, String password, int id);

    void changeSendMail(Collection<Integer> ids);

}
