package com.baijia.tianxiao.dal.finance.po;

import java.util.Date;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * Created by wengshengli on 2017/4/21.
 */
@Data
@Entity
@Table(name = "tx_transfer_class_record", catalog = "yunying")
public class TxTransferClassRecord extends BaseDto {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @Column(name = "transfer_number")
    private Long transferNumber;

    @Column(name = "transfer_out_class_id")
    private Long transferOutClassId;

    @Column(name = "transfer_out_user_id")
    private Long transferOutUserId;

    @Column(name = "out_purchase_id")
    private Long outPurchaseId;
    

    @Column(name = "in_purchase_id")
    private Long inPurchaseId;

    @Column(name = "lesson_id")
    private Long lessonId;

    @Column(name = "charge_unit")
    private Integer chargeUnit;

    @Column(name = "real_lesson_count")
    private Integer realLessonCount = 0;

    @Column(name = "free_lesson_count")
    private Integer freeLessonCount = 0;

    @Column(name = "lesson_money")
    private Integer lessonMoney = 0;

    @Column(name = "refund_money")
    private Integer refundMoney = 0;

    @Column(name = "refund_type")
    private Integer refundType;

    @Column(name = "sync_refund")
    private Integer syncRefund;

    @Column(name = "status")
    private Integer status;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    public Integer getTransferLessonCount() {
        return this.getRealLessonCount() + this.getFreeLessonCount();
    }
}
